/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import org.jboss.weld.bootstrap.events.AnnotationDiscovery;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

public class ProcessAnnotatedTypeEventResolvable
implements Resolvable {
    private static final Set<QualifierInstance> QUALIFIERS = Collections.singleton(QualifierInstance.ANY);
    private final Set<Type> types;
    private final Class<?> javaClass;
    private final AnnotationDiscovery discovery;

    public static ProcessAnnotatedTypeEventResolvable forProcessAnnotatedType(Class<?> typeArgument, AnnotationDiscovery discovery) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl((Type)((Object)ProcessAnnotatedType.class), new Type[]{typeArgument}, null);
        return new ProcessAnnotatedTypeEventResolvable(Sets.newHashSet(Object.class, type), typeArgument, discovery);
    }

    public static ProcessAnnotatedTypeEventResolvable forProcessSyntheticAnnotatedType(Class<?> typeArgument, AnnotationDiscovery discovery) {
        ParameterizedTypeImpl type1 = new ParameterizedTypeImpl((Type)((Object)ProcessAnnotatedType.class), new Type[]{typeArgument}, null);
        ParameterizedTypeImpl type2 = new ParameterizedTypeImpl((Type)((Object)ProcessSyntheticAnnotatedType.class), new Type[]{typeArgument}, null);
        return new ProcessAnnotatedTypeEventResolvable(Sets.newHashSet(Object.class, type1, type2), typeArgument, discovery);
    }

    protected ProcessAnnotatedTypeEventResolvable(Set<Type> types, Class<?> javaClass, AnnotationDiscovery discovery) {
        this.types = types;
        this.javaClass = javaClass;
        this.discovery = discovery;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public Set<QualifierInstance> getQualifiers() {
        return QUALIFIERS;
    }

    public boolean containsRequiredAnnotations(Collection<Class<? extends Annotation>> requiredAnnotations) {
        return this.discovery.containsAnnotations(this.javaClass, requiredAnnotations);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return false;
    }

    @Override
    public Class<?> getJavaClass() {
        return null;
    }

    @Override
    public Bean<?> getDeclaringBean() {
        return null;
    }

    @Override
    public boolean isDelegate() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessAnnotatedTypeEventResolvable)) {
            return false;
        }
        ProcessAnnotatedTypeEventResolvable other = (ProcessAnnotatedTypeEventResolvable)obj;
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }
}

