/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ProcessModule;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.enablement.ClassEnablement;
import org.jboss.weld.bootstrap.enablement.ModuleEnablementBuilder;
import org.jboss.weld.bootstrap.events.AbstractDeploymentContainerEvent;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ListToSet;
import org.jboss.weld.util.collections.ListView;
import org.jboss.weld.util.collections.SetView;
import org.jboss.weld.util.collections.ViewProvider;
import org.jboss.weld.util.reflection.Reflections;

public class ProcessModuleImpl
extends AbstractDeploymentContainerEvent
implements ProcessModule {
    private final BeanDeployment deployment;
    private final ClassMetadaViewProvider viewProvider = new ClassMetadaViewProvider();
    private final ModuleEnablementBuilder moduleEnablementBuilder;

    public static ProcessModuleImpl fire(BeanDeployment deployment) {
        ProcessModuleImpl event = new ProcessModuleImpl(deployment.getBeanManager(), deployment);
        event.fire();
        return event;
    }

    protected ProcessModuleImpl(BeanManagerImpl beanManager, BeanDeployment deployment) {
        super(beanManager, (Type)((Object)ProcessModule.class), Reflections.EMPTY_TYPES);
        this.deployment = deployment;
        this.moduleEnablementBuilder = deployment.getModuleEnablementBuilder();
    }

    @Override
    public Set<Class<?>> getAlternatives() {
        return new SetView<ClassEnablement, Class<?>>(){

            @Override
            protected Set<ClassEnablement> getDelegate() {
                return new ListToSet<ClassEnablement>(){

                    @Override
                    public boolean add(ClassEnablement e) {
                        return this.delegate().add(e);
                    }

                    @Override
                    protected List<ClassEnablement> delegate() {
                        return ProcessModuleImpl.this.moduleEnablementBuilder.getAlternatives();
                    }
                };
            }

            @Override
            protected ViewProvider<ClassEnablement, Class<?>> getViewProvider() {
                return ProcessModuleImpl.this.viewProvider;
            }
        };
    }

    @Override
    public List<Class<?>> getInterceptors() {
        return new ListView<ClassEnablement, Class<?>>(){

            @Override
            protected List<ClassEnablement> getDelegate() {
                return ProcessModuleImpl.this.moduleEnablementBuilder.getInterceptors();
            }

            @Override
            protected ViewProvider<ClassEnablement, Class<?>> getViewProvider() {
                return ProcessModuleImpl.this.viewProvider;
            }
        };
    }

    @Override
    public List<Class<?>> getDecorators() {
        return new ListView<ClassEnablement, Class<?>>(){

            @Override
            protected List<ClassEnablement> getDelegate() {
                return ProcessModuleImpl.this.moduleEnablementBuilder.getDecorators();
            }

            @Override
            protected ViewProvider<ClassEnablement, Class<?>> getViewProvider() {
                return ProcessModuleImpl.this.viewProvider;
            }
        };
    }

    @Override
    public Iterator<AnnotatedType<?>> getAnnotatedTypes() {
        return (Iterator)Reflections.cast(((BeanDeployerEnvironment)this.deployment.getBeanDeployer().getEnvironment()).getAnnotatedTypes().iterator());
    }

    @Override
    public InputStream getBeansXml() {
        try {
            return this.deployment.getBeanDeploymentArchive().getBeansXml().getUrl().openStream();
        }
        catch (IOException e) {
            throw new WeldException(XmlMessage.EXCEPTION_OPENING_INPUT_STREAM, (Throwable)e, this.deployment.getBeanDeploymentArchive().getBeansXml().getUrl());
        }
    }

    private class ClassMetadaViewProvider
    implements ViewProvider<ClassEnablement, Class<?>> {
        private ClassMetadaViewProvider() {
        }

        @Override
        public Class<?> toView(ClassEnablement from) {
            return from.getEnabledClass();
        }

        @Override
        public ClassEnablement fromView(Class<?> to) {
            StringBuilder location = new StringBuilder();
            location.append(to.getName());
            location.append(" registered by ");
            if (ProcessModuleImpl.this.getObserverMethod() instanceof ExtensionObserverMethodImpl) {
                location.append(((ExtensionObserverMethodImpl)ProcessModuleImpl.this.getObserverMethod()).getBeanClass().getName());
            } else {
                location.append("an extension.");
            }
            return new ClassEnablement(to, location.toString(), null);
        }
    }
}

