/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.EventObjectTypeResolverBuilder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.TypeResolver;

@SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR"}, justification="Uses SerializationProxy")
public class EventImpl<T>
extends AbstractFacade<T, Event<T>>
implements Event<T>,
Serializable {
    private static final long serialVersionUID = 656782657242515455L;
    private final transient HierarchyDiscovery injectionPointTypeHierarchy = new HierarchyDiscovery(this.getType());

    public static <E> EventImpl<E> of(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        return new EventImpl(injectionPoint, beanManager);
    }

    private EventImpl(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        super(injectionPoint, null, beanManager);
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Event<" + Formats.formatType(this.getType()) + ">";
    }

    @Override
    public void fire(T event) {
        this.getBeanManager().getGlobalStrictObserverNotifier().fireEvent(this.getEventType(event), event, this.getQualifiers());
    }

    @Override
    public Event<T> select(Annotation ... qualifiers) {
        return this.selectEvent(this.getType(), qualifiers);
    }

    @Override
    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectEvent(subtype, qualifiers);
    }

    @Override
    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectEvent(subtype.getType(), qualifiers);
    }

    private <U extends T> Event<U> selectEvent(Type subtype, Annotation[] newQualifiers) {
        this.getBeanManager().getGlobalStrictObserverNotifier().checkEventObjectType(subtype);
        return new EventImpl<T>(new FacadeInjectionPoint(this.getInjectionPoint(), subtype, this.getQualifiers(), newQualifiers), this.getBeanManager());
    }

    protected Type getEventType(T event) {
        Type resolvedType = event.getClass();
        if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
            resolvedType = this.injectionPointTypeHierarchy.resolveType(resolvedType);
        }
        if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
            TypeResolver objectTypeResolver = new EventObjectTypeResolverBuilder(this.injectionPointTypeHierarchy.getResolver().getResolvedTypeVariables(), new HierarchyDiscovery(event.getClass()).getResolver().getResolvedTypeVariables()).build();
            resolvedType = objectTypeResolver.resolveType(Types.getCanonicalType(event.getClass()));
        }
        return resolvedType;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(EventMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Event<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(EventImpl<T> event) {
            super(event);
        }

        private Object readResolve() {
            return EventImpl.of(this.getInjectionPoint(), this.getBeanManager());
        }
    }
}

