/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.event.TransactionalObserverNotifier;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.Reflections;

public class ObserverNotifier {
    private static final RuntimeException NO_EXCEPTION_MARKER = new RuntimeException();
    private final TypeSafeObserverResolver resolver;
    private final SharedObjectCache sharedObjectCache;
    private final boolean strict;
    private final ConcurrentMap<Type, RuntimeException> eventTypeCheckCache;

    public static ObserverNotifier of(TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        if (services.contains(TransactionServices.class)) {
            return new TransactionalObserverNotifier(resolver, services, strict);
        }
        return new ObserverNotifier(resolver, services, strict);
    }

    protected ObserverNotifier(TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        this.resolver = resolver;
        this.sharedObjectCache = services.get(SharedObjectCache.class);
        this.strict = strict;
        this.eventTypeCheckCache = strict ? new MapMaker().makeComputingMap(new EventTypeCheck()) : null;
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        this.checkEventObjectType(event);
        return this.resolveObserverMethods((Type)event.getClass(), bindings);
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        this.checkEventObjectType(eventType);
        HashSet<Annotation> qualifierSet = new HashSet<Annotation>(Arrays.asList(qualifiers));
        this.notifyObservers(event, qualifierSet, this.resolveObserverMethods(eventType, qualifiers));
    }

    public void fireEvent(Type eventType, Object event, Set<Annotation> qualifiers) {
        this.checkEventObjectType(eventType);
        this.notifyObservers(event, qualifiers, this.resolveObserverMethods(eventType, qualifiers));
    }

    public void fireEvent(Object event, Resolvable resolvable) {
        this.checkEventObjectType(event);
        this.notifyObservers(event, Collections.<Annotation>emptySet(), this.resolveObserverMethods(resolvable));
    }

    private <T> void notifyObservers(T event, Set<Annotation> qualifiers, Set<ObserverMethod<? super T>> observers) {
        for (ObserverMethod<T> observerMethod : observers) {
            if (!(observerMethod instanceof ObserverMethodImpl) && !qualifiers.contains(AnyLiteral.INSTANCE)) {
                qualifiers = new HashSet<Annotation>(qualifiers);
                qualifiers.add(AnyLiteral.INSTANCE);
                qualifiers = Collections.unmodifiableSet(qualifiers);
            }
            this.notifyObserver(event, qualifiers, observerMethod);
        }
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Annotation ... qualifiers) {
        Resolvable resolvable = new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(this.sharedObjectCache.getTypeClosureHolder(eventType).get()).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent(AnyLiteral.INSTANCE).create();
        return this.resolveObserverMethods(resolvable);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Set<Annotation> qualifiers) {
        Set<Type> typeClosure = this.sharedObjectCache.getTypeClosureHolder(eventType).get();
        Resolvable resolvable = new ResolvableBuilder(this.resolver.getMetaAnnotationStore()).addTypes(typeClosure).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent(AnyLiteral.INSTANCE).create();
        return this.resolveObserverMethods(resolvable);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Resolvable resolvable) {
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public void clear() {
        this.resolver.clear();
        if (this.eventTypeCheckCache != null) {
            this.eventTypeCheckCache.clear();
        }
    }

    protected <T> void notifyObserver(T event, Set<Annotation> qualifiers, ObserverMethod<? super T> observer) {
        observer.notify(event, qualifiers);
    }

    public void checkEventObjectType(Object event) {
        this.checkEventObjectType(event.getClass());
    }

    public void checkEventObjectType(Type eventType) {
        RuntimeException exception;
        if (this.strict && (exception = (RuntimeException)this.eventTypeCheckCache.get(eventType)) != NO_EXCEPTION_MARKER) {
            throw exception;
        }
    }

    private class EventTypeCheck
    implements Function<Type, RuntimeException> {
        private EventTypeCheck() {
        }

        @Override
        public RuntimeException apply(Type eventType) {
            Type resolvedType = Types.getCanonicalType(eventType);
            if (Types.containsUnresolvedTypeVariableOrWildcard(resolvedType)) {
                return new IllegalArgumentException(UtilMessage.TYPE_PARAMETER_NOT_ALLOWED_IN_EVENT_TYPE, eventType);
            }
            Class resolvedClass = Reflections.getRawType(eventType);
            for (Class clazz : Observers.CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES) {
                if (!clazz.isAssignableFrom(resolvedClass)) continue;
                return new IllegalArgumentException(UtilMessage.EVENT_TYPE_NOT_ALLOWED, eventType);
            }
            return NO_EXCEPTION_MARKER;
        }
    }
}

