/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import org.jboss.weld.bootstrap.BootstrapConfiguration;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.executor.FixedThreadPoolExecutorServices;
import org.jboss.weld.executor.ProfilingExecutorServices;
import org.jboss.weld.executor.SingleThreadExecutorServices;
import org.jboss.weld.executor.TimingOutFixedThreadPoolExecutorServices;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.api.ExecutorServices;

public class ExecutorServicesFactory {
    private ExecutorServicesFactory() {
    }

    public static ExecutorServices create(BootstrapConfiguration configuration) {
        if (!configuration.isThreadingEnabled()) {
            return null;
        }
        if (!configuration.isConcurrentDeployerEnabled()) {
            return new SingleThreadExecutorServices();
        }
        ExecutorServices executor = null;
        switch (configuration.getThreadPoolType()) {
            case FIXED: {
                executor = new FixedThreadPoolExecutorServices(configuration.getDeployerThreads());
                break;
            }
            case FIXED_TIMEOUT: {
                executor = new TimingOutFixedThreadPoolExecutorServices(configuration.getDeployerThreads(), configuration.getThreadPoolKeepAliveTime());
                break;
            }
            default: {
                throw new DeploymentException(BootstrapMessage.INVALID_THREAD_POOL_TYPE, new Object[]{configuration.getThreadPoolType()});
            }
        }
        if (configuration.isDebug()) {
            executor = new ProfilingExecutorServices(executor);
        }
        return executor;
    }
}

