/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.weld.bootstrap.BootstrapConfiguration;
import org.jboss.weld.executor.AbstractExecutorServices;
import org.jboss.weld.executor.DeamonThreadFactory;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.slf4j.cal10n.LocLogger;

public class FixedThreadPoolExecutorServices
extends AbstractExecutorServices {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final int threadPoolSize;
    private final ExecutorService executor;

    public FixedThreadPoolExecutorServices() {
        this(BootstrapConfiguration.DEFAULT_THREAD_POOL_SIZE);
    }

    public FixedThreadPoolExecutorServices(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        this.executor = Executors.newFixedThreadPool(threadPoolSize, new DeamonThreadFactory(new ThreadGroup("weld-workers"), "weld-worker-"));
        log.debug(BootstrapMessage.THREADS_IN_USE, threadPoolSize);
    }

    @Override
    public ExecutorService getTaskExecutor() {
        return this.executor;
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String toString() {
        return "FixedThreadPoolExecutorServices [threadPoolSize=" + this.threadPoolSize + "]";
    }
}

