/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.runtime.RuntimeAnnotatedMembers;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.producer.AbstractProducer;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.collections.WeldCollections;

public abstract class AbstractInjectionTarget<T>
extends AbstractProducer<T>
implements InjectionTarget<T> {
    protected final BeanManagerImpl beanManager;
    private final AnnotatedType<T> type;
    private final List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private final List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private final List<AnnotatedMethod<? super T>> postConstructMethods;
    private final List<AnnotatedMethod<? super T>> preDestroyMethods;
    private final Set<InjectionPoint> injectionPoints;
    private final Bean<T> bean;
    private Instantiator<T> instantiator;

    public AbstractInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.type = type.slim();
        HashSet<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
        this.bean = bean;
        this.injectableFields = InjectionPointFactory.instance().getFieldInjectionPoints(bean, type, beanManager);
        injectionPoints.addAll(InjectionPoints.flattenInjectionPoints(this.injectableFields));
        this.initializerMethods = BeanMethods.getInitializerMethods(bean, type, beanManager);
        injectionPoints.addAll(InjectionPoints.flattenParameterInjectionPoints(this.initializerMethods));
        if (this.isInterceptor()) {
            this.postConstructMethods = Collections.emptyList();
            this.preDestroyMethods = Collections.emptyList();
        } else {
            this.postConstructMethods = BeanMethods.getPostConstructMethods(type);
            this.preDestroyMethods = BeanMethods.getPreDestroyMethods(type);
        }
        this.checkType(type);
        this.instantiator = this.initInstantiator(type, bean, beanManager, injectionPoints);
        this.injectionPoints = WeldCollections.immutableSet(injectionPoints);
        this.checkDelegateInjectionPoints();
    }

    protected void checkType(EnhancedAnnotatedType<T> type) {
        if (type.isAnonymousClass() || type.isMemberClass() && !type.isStatic()) {
            throw new DefinitionException(BeanMessage.SIMPLE_BEAN_AS_NON_STATIC_INNER_CLASS_NOT_ALLOWED, type);
        }
    }

    protected void checkDecoratedMethods(EnhancedAnnotatedType<T> type, List<Decorator<?>> decorators) {
        if (type.isFinal()) {
            throw new DeploymentException(BeanMessage.FINAL_BEAN_CLASS_WITH_DECORATORS_NOT_ALLOWED, this);
        }
        for (Decorator<?> decorator : decorators) {
            EnhancedAnnotatedType<?> decoratorClass;
            if (decorator instanceof DecoratorImpl) {
                DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                decoratorClass = decoratorBean.getAnnotated();
            } else if (decorator instanceof CustomDecoratorWrapper) {
                decoratorClass = ((CustomDecoratorWrapper)decorator).getEnhancedAnnotated();
            } else {
                throw new IllegalStateException(BeanMessage.NON_CONTAINER_DECORATOR, decorator);
            }
            EnhancedAnnotatedType<?> enhancedDecoratorClass = this.beanManager.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(decoratorClass);
            for (EnhancedAnnotatedMethod<?, ?> decoratorMethod : enhancedDecoratorClass.getEnhancedMethods()) {
                EnhancedAnnotatedMethod method = type.getEnhancedMethod(decoratorMethod.getSignature());
                if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                throw new DeploymentException(BeanMessage.FINAL_BEAN_CLASS_WITH_INTERCEPTORS_NOT_ALLOWED, method, decoratorMethod);
            }
        }
    }

    protected boolean isInterceptor() {
        return this.bean instanceof Interceptor || this.type.isAnnotationPresent(javax.interceptor.Interceptor.class);
    }

    protected boolean isDecorator() {
        return this.bean instanceof Decorator || this.type.isAnnotationPresent(javax.decorator.Decorator.class);
    }

    protected boolean isInterceptionCandidate() {
        return !this.isInterceptor() && !this.isDecorator();
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        T instance = this.instantiator.newInstance(ctx, this.beanManager);
        if (this.bean != null && !this.bean.getScope().equals(Dependent.class) && !this.instantiator.hasDecoratorSupport()) {
            ctx.push(instance);
        }
        return instance;
    }

    @Override
    public void postConstruct(T instance) {
        for (AnnotatedMethod<? super T> annotatedMethod : this.postConstructMethods) {
            if (annotatedMethod == null) continue;
            try {
                RuntimeAnnotatedMembers.invokeMethod(annotatedMethod, instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, annotatedMethod, instance);
            }
        }
    }

    @Override
    public void preDestroy(T instance) {
        for (AnnotatedMethod<? super T> annotatedMethod : this.preDestroyMethods) {
            if (annotatedMethod == null) continue;
            try {
                RuntimeAnnotatedMembers.invokeMethod(annotatedMethod, instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, annotatedMethod, instance);
            }
        }
    }

    @Override
    public void dispose(T instance) {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    protected AnnotatedType<T> getType() {
        return this.type;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public List<Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return this.injectableFields;
    }

    public List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return this.initializerMethods;
    }

    public Instantiator<T> getInstantiator() {
        return this.instantiator;
    }

    public void setInstantiator(Instantiator<T> instantiator) {
        this.instantiator = instantiator;
    }

    @Override
    public Bean<T> getBean() {
        return this.bean;
    }

    public boolean hasInterceptors() {
        return this.instantiator.hasInterceptorSupport();
    }

    public boolean hasDecorators() {
        return this.instantiator.hasDecoratorSupport();
    }

    public List<AnnotatedMethod<? super T>> getPostConstructMethods() {
        return this.postConstructMethods;
    }

    public List<AnnotatedMethod<? super T>> getPreDestroyMethods() {
        return this.preDestroyMethods;
    }

    protected void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
        if (this.isInterceptionCandidate() && !this.beanManager.getInterceptorModelRegistry().containsKey(annotatedType.getJavaClass())) {
            new InterceptionModelInitializer<T>(this.beanManager, annotatedType, this.getBean()).init();
        }
    }

    protected abstract Instantiator<T> initInstantiator(EnhancedAnnotatedType<T> var1, Bean<T> var2, BeanManagerImpl var3, Set<InjectionPoint> var4);

    @Override
    public AnnotatedType<T> getAnnotated() {
        return this.type;
    }

    public String toString() {
        if (this.getBean() == null) {
            return "InjectionTarget for " + this.getAnnotated();
        }
        return "InjectionTarget for " + this.getBean();
    }
}

