/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;
import org.jboss.weld.interceptor.spi.context.InvocationContextFactory;
import org.jboss.weld.interceptor.spi.instance.InterceptorInstantiator;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.util.reflection.SecureReflections;

public class InterceptorMethodHandler
implements MethodHandler,
Serializable {
    private static final MethodHandler DEFAULT_METHOD_HANDLER = new MethodHandler(){

        @Override
        public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Exception {
            return proceed.invoke(self, args);
        }
    };
    private final Map<InterceptorMetadata<?>, Object> interceptorHandlerInstances;
    private final InterceptorMetadata<ClassMetadata<?>> targetClassInterceptorMetadata;
    private final InterceptionModel<ClassMetadata<?>, ?> interceptionModel;
    private final Object targetInstance;
    private final InvocationContextFactory invocationContextFactory;

    public InterceptorMethodHandler(Object targetInstance, ClassMetadata<?> targetClassMetadata, InterceptionModel<ClassMetadata<?>, ?> interceptionModel, InterceptorInstantiator<?, ?> interceptorInstantiator, InvocationContextFactory invocationContextFactory) {
        this.targetInstance = targetInstance;
        this.invocationContextFactory = invocationContextFactory;
        if (interceptionModel == null) {
            throw new IllegalArgumentException("Interception model must not be null");
        }
        if (interceptorInstantiator == null) {
            throw new IllegalArgumentException("Interception handler factory must not be null");
        }
        this.interceptionModel = interceptionModel;
        Set<InterceptorMetadata<?>> allInterceptors = this.interceptionModel.getAllInterceptors();
        this.interceptorHandlerInstances = new HashMap(allInterceptors.size());
        for (InterceptorMetadata<?> interceptorMetadata : allInterceptors) {
            this.interceptorHandlerInstances.put(interceptorMetadata, interceptorInstantiator.createFor(interceptorMetadata.getInterceptorReference()));
        }
        this.targetClassInterceptorMetadata = InterceptorMetadataUtils.readMetadataForTargetClass(targetClassMetadata);
    }

    protected boolean isProxy() {
        return this.targetInstance != null;
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        SecureReflections.ensureAccessible(thisMethod);
        if (proceed == null) {
            if (thisMethod.getName().equals("lifecycle_mixin_$$_postConstruct")) {
                return this.executeInterception(this.isProxy() ? null : self, null, null, null, InterceptionType.POST_CONSTRUCT);
            }
            if (thisMethod.getName().equals("lifecycle_mixin_$$_preDestroy")) {
                return this.executeInterception(this.isProxy() ? null : self, null, null, null, InterceptionType.PRE_DESTROY);
            }
        } else {
            if (this.isInterceptorMethod(thisMethod)) {
                if (this.isProxy()) {
                    return thisMethod.invoke(this.targetInstance, args);
                }
                return proceed.invoke(self, args);
            }
            return this.executeInterception(this.isProxy() ? null : self, thisMethod, thisMethod, args, InterceptionType.AROUND_INVOKE);
        }
        return null;
    }

    private boolean isInterceptorMethod(Method method) {
        MethodMetadata methodMetadata = this.targetClassInterceptorMetadata.getInterceptorClass().getDeclaredMethod(method);
        return methodMetadata != null && methodMetadata.isInterceptorMethod();
    }

    private Object executeInterception(Object self, Method proceedingMethod, Method thisMethod, Object[] args, InterceptionType interceptionType) throws Throwable {
        List<InterceptorMetadata<?>> interceptorList = this.interceptionModel.getInterceptors(interceptionType, thisMethod);
        ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(interceptorList.size());
        for (InterceptorMetadata<?> interceptorReference : interceptorList) {
            interceptorInvocations.add(interceptorReference.getInterceptorInvocation(this.interceptorHandlerInstances.get(interceptorReference), interceptorReference, interceptionType));
        }
        if (this.targetClassInterceptorMetadata != null && this.targetClassInterceptorMetadata.isEligible(interceptionType)) {
            interceptorInvocations.add(this.targetClassInterceptorMetadata.getInterceptorInvocation(this.isProxy() ? this.targetInstance : self, this.targetClassInterceptorMetadata, interceptionType));
        }
        SimpleInterceptionChain chain = new SimpleInterceptionChain(interceptorInvocations, this.isProxy() ? this.targetInstance : self, this.isProxy() ? thisMethod : proceedingMethod);
        return chain.invokeNextInterceptor(this.invocationContextFactory.newInvocationContext((InterceptionChain)chain, this.isProxy() ? this.targetInstance : self, this.isProxy() ? thisMethod : proceedingMethod, args));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.executeInterception(this.isProxy() ? this.targetInstance : null, null, null, null, InterceptionType.PRE_PASSIVATE);
            objectOutputStream.defaultWriteObject();
        }
        catch (Throwable throwable) {
            throw new IOException("Error while serializing class", throwable);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.isProxy() && this.targetInstance instanceof ProxyObject && ((ProxyObject)this.targetInstance).getHandler() == null) {
                ((ProxyObject)this.targetInstance).setHandler(DEFAULT_METHOD_HANDLER);
            }
            this.executeInterception(this.isProxy() ? this.targetInstance : null, null, null, null, InterceptionType.POST_ACTIVATE);
        }
        catch (Throwable throwable) {
            throw new IOException("Error while deserializing class", throwable);
        }
    }
}

