/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.AbstractSerializableHolder;
import org.jboss.weld.serialization.BeanHolder;
import org.jboss.weld.serialization.ConstructorHolder;
import org.jboss.weld.serialization.FieldHolder;
import org.jboss.weld.serialization.MethodHolder;
import org.jboss.weld.util.reflection.Reflections;

public class InjectionPointHolder
extends AbstractSerializableHolder<InjectionPoint> {
    private static final long serialVersionUID = -6128821485743815308L;
    private final InjectionPointIdentifier identifier;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InjectionPointHolder(InjectionPoint ip) {
        super(ip);
        if (ip.getBean() == null) {
            this.identifier = new NoopInjectionPointIdentifier(ip);
            return;
        } else if (ip.getAnnotated() instanceof AnnotatedField) {
            AnnotatedField field = (AnnotatedField)Reflections.cast(ip.getAnnotated());
            this.identifier = new FieldInjectionPointIdentifier(ip.getBean(), field);
            return;
        } else {
            if (!(ip.getAnnotated() instanceof AnnotatedParameter)) throw new IllegalArgumentException(BeanMessage.INVALID_ANNOTATED_OF_INJECTION_POINT, ip.getAnnotated(), ip);
            AnnotatedParameter parameter = (AnnotatedParameter)Reflections.cast(ip.getAnnotated());
            if (parameter.getDeclaringCallable() instanceof AnnotatedConstructor) {
                AnnotatedConstructor constructor = (AnnotatedConstructor)Reflections.cast(parameter.getDeclaringCallable());
                this.identifier = new ConstructorParameterInjectionPointIdentifier(ip.getBean(), parameter.getPosition(), constructor);
                return;
            } else {
                if (!(parameter.getDeclaringCallable() instanceof AnnotatedMethod)) throw new IllegalArgumentException(BeanMessage.INVALID_ANNOTATED_CALLABLE, parameter.getDeclaringCallable());
                AnnotatedMethod method = (AnnotatedMethod)Reflections.cast(parameter.getDeclaringCallable());
                this.identifier = new MethodParameterInjectionPointIdentifier(ip.getBean(), parameter.getPosition(), method);
            }
        }
    }

    @Override
    protected InjectionPoint initialize() {
        return this.identifier.restoreInjectionPoint();
    }

    private static class MethodParameterInjectionPointIdentifier
    extends AbstractParameterInjectionPointIdentifier {
        private static final long serialVersionUID = -3263543692438746424L;
        private final MethodHolder method;

        public MethodParameterInjectionPointIdentifier(Bean<?> bean, int position, AnnotatedMethod<?> constructor) {
            super(bean, position);
            this.method = new MethodHolder(constructor.getJavaMember());
        }

        @Override
        protected boolean matches(InjectionPoint ip, AnnotatedCallable<?> annotatedCallable) {
            if (annotatedCallable instanceof AnnotatedMethod) {
                AnnotatedMethod annotatedMethod = (AnnotatedMethod)Reflections.cast(annotatedCallable);
                return ((Method)this.method.get()).equals(annotatedMethod.getJavaMember());
            }
            return false;
        }
    }

    private static class ConstructorParameterInjectionPointIdentifier
    extends AbstractParameterInjectionPointIdentifier {
        private static final long serialVersionUID = 638702977751948835L;
        private final ConstructorHolder<?> constructor;

        public ConstructorParameterInjectionPointIdentifier(Bean<?> bean, int position, AnnotatedConstructor<?> constructor) {
            super(bean, position);
            this.constructor = ConstructorHolder.of(constructor.getJavaMember());
        }

        @Override
        protected boolean matches(InjectionPoint ip, AnnotatedCallable<?> annotatedCallable) {
            if (annotatedCallable instanceof AnnotatedConstructor) {
                AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)Reflections.cast(annotatedCallable);
                return ((Constructor)this.constructor.get()).equals(annotatedConstructor.getJavaMember());
            }
            return false;
        }
    }

    private static abstract class AbstractParameterInjectionPointIdentifier
    extends AbstractInjectionPointIdentifier {
        private static final long serialVersionUID = -3618042716814281161L;
        private final int position;

        public AbstractParameterInjectionPointIdentifier(Bean<?> bean, int position) {
            super(bean);
            this.position = position;
        }

        @Override
        protected boolean matches(InjectionPoint ip) {
            if (ip.getAnnotated() instanceof AnnotatedParameter) {
                AnnotatedParameter annotatedParameter = (AnnotatedParameter)Reflections.cast(ip.getAnnotated());
                return this.position == annotatedParameter.getPosition() && this.matches(ip, annotatedParameter.getDeclaringCallable());
            }
            return false;
        }

        protected abstract boolean matches(InjectionPoint var1, AnnotatedCallable<?> var2);
    }

    private static class FieldInjectionPointIdentifier
    extends AbstractInjectionPointIdentifier {
        private static final long serialVersionUID = 4581216810217284043L;
        private final FieldHolder field;

        public FieldInjectionPointIdentifier(Bean<?> bean, AnnotatedField<?> field) {
            super(bean);
            this.field = new FieldHolder(field.getJavaMember());
        }

        @Override
        protected boolean matches(InjectionPoint ip) {
            if (ip.getAnnotated() instanceof AnnotatedField) {
                AnnotatedField annotatedField = (AnnotatedField)Reflections.cast(ip.getAnnotated());
                return ((Field)this.field.get()).equals(annotatedField.getJavaMember());
            }
            return false;
        }
    }

    private static abstract class AbstractInjectionPointIdentifier
    implements InjectionPointIdentifier {
        private static final long serialVersionUID = -8167922066673252787L;
        private final BeanHolder<?> bean;

        public AbstractInjectionPointIdentifier(Bean<?> bean) {
            this.bean = BeanHolder.of(bean);
        }

        @Override
        public InjectionPoint restoreInjectionPoint() {
            InjectionPoint injectionPoint = null;
            for (InjectionPoint ip : ((Bean)this.bean.get()).getInjectionPoints()) {
                if (!this.matches(ip)) continue;
                if (injectionPoint != null) {
                    throw new IllegalStateException(BeanMessage.UNABLE_TO_RESTORE_INJECTION_POINT_MULTIPLE, this.bean.get(), injectionPoint, ip);
                }
                injectionPoint = ip;
            }
            if (injectionPoint == null) {
                throw new IllegalStateException(BeanMessage.UNABLE_TO_RESTORE_INJECTION_POINT, this.bean.get());
            }
            return injectionPoint;
        }

        protected abstract boolean matches(InjectionPoint var1);
    }

    private static class NoopInjectionPointIdentifier
    implements InjectionPointIdentifier {
        private static final long serialVersionUID = 6952579330771485841L;
        private final InjectionPoint ip;

        public NoopInjectionPointIdentifier(InjectionPoint ip) {
            this.ip = ip;
        }

        @Override
        public InjectionPoint restoreInjectionPoint() {
            return this.ip;
        }
    }

    private static interface InjectionPointIdentifier
    extends Serializable {
        public InjectionPoint restoreInjectionPoint();
    }
}

