/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.annotated.runtime.InvokableAnnotatedMethod;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

public class Decorators {
    public static Map<MethodSignature, InvokableAnnotatedMethod<?>> getDecoratorMethods(BeanManagerImpl beanManager, Set<Type> decoratedTypes, EnhancedAnnotatedType<?> decoratorClass) {
        List<EnhancedAnnotatedMethod<?, ?>> decoratedMethods = Decorators.getDecoratedMethods(beanManager, decoratedTypes);
        HashMap decoratorMethods = new HashMap();
        for (EnhancedAnnotatedMethod<?, ?> method : decoratorClass.getEnhancedMethods()) {
            MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
            for (EnhancedAnnotatedMethod<?, ?> decoratedMethod : decoratedMethods) {
                if (!new MethodSignatureImpl(decoratedMethod).equals(methodSignature)) continue;
                decoratorMethods.put(methodSignature, InvokableAnnotatedMethod.of(decoratedMethod.slim()));
            }
        }
        return decoratorMethods;
    }

    public static List<EnhancedAnnotatedMethod<?, ?>> getDecoratedMethods(BeanManagerImpl beanManager, Set<Type> decoratedTypes) {
        ArrayList methods = new ArrayList();
        for (Type type : decoratedTypes) {
            EnhancedAnnotatedType<?> weldClass = Decorators.getWeldClassOfDecoratedType(beanManager, type);
            for (EnhancedAnnotatedMethod<?, ?> method : weldClass.getEnhancedMethods()) {
                if (methods.contains(method)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static EnhancedAnnotatedType<?> getWeldClassOfDecoratedType(BeanManagerImpl beanManager, Type type) {
        if (type instanceof Class) {
            return beanManager.createEnhancedAnnotatedType((Class)type);
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return beanManager.createEnhancedAnnotatedType((Class)((ParameterizedType)type).getRawType());
        }
        throw new IllegalStateException(BeanMessage.UNABLE_TO_PROCESS, type);
    }

    public static <T> InvokableAnnotatedMethod<?> findDecoratorMethod(WeldDecorator<T> decorator, Map<MethodSignature, InvokableAnnotatedMethod<?>> decoratorMethods, Method method) {
        MethodSignatureImpl key = new MethodSignatureImpl(method);
        InvokableAnnotatedMethod<?> foundMethod = decoratorMethods.get(key);
        if (foundMethod != null) {
            return foundMethod;
        }
        for (InvokableAnnotatedMethod<?> decoratorMethod : decoratorMethods.values()) {
            if (method.getParameterTypes().length != decoratorMethod.getParameters().size() || !method.getName().equals(decoratorMethod.getJavaMember().getName())) continue;
            boolean parameterMatch = true;
            for (int i = 0; parameterMatch && i < method.getParameterTypes().length; ++i) {
                parameterMatch = parameterMatch && decoratorMethod.getJavaMember().getParameterTypes()[i].isAssignableFrom(method.getParameterTypes()[i]);
            }
            if (!parameterMatch) continue;
            return decoratorMethod;
        }
        return null;
    }

    public static WeldInjectionPoint<?, ?> findDelegateInjectionPoint(AnnotatedType<?> type, Iterable<InjectionPoint> injectionPoints) {
        WeldInjectionPoint result = null;
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (!injectionPoint.isDelegate()) continue;
            if (result != null) {
                throw new DefinitionException(BeanMessage.TOO_MANY_DELEGATES_FOR_DECORATOR, type);
            }
            if (injectionPoint instanceof MethodInjectionPoint && !injectionPoint.getAnnotated().isAnnotationPresent(Inject.class)) {
                throw new DefinitionException(BeanMessage.DELEGATE_ON_NON_INITIALIZER_METHOD, injectionPoint);
            }
            result = InjectionPoints.getWeldInjectionPoint(injectionPoint);
        }
        if (result == null) {
            throw new DefinitionException(BeanMessage.NO_DELEGATE_FOR_DECORATOR, type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getOuterDelegate(Bean<T> bean, T instance, CreationalContext<T> creationalContext, Class<T> proxyClass, InjectionPoint originalInjectionPoint, BeanManagerImpl manager, List<Decorator<?>> decorators) {
        TargetBeanInstance beanInstance = new TargetBeanInstance(bean, instance);
        DecorationHelper<T> decorationHelper = new DecorationHelper<T>(beanInstance, bean, proxyClass, manager, manager.getServices().get(ContextualStore.class), decorators);
        DecorationHelper.push(decorationHelper);
        try {
            T outerDelegate = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
            if (outerDelegate == null) {
                throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, bean);
            }
            T t = outerDelegate;
            return t;
        }
        finally {
            DecorationHelper.pop();
        }
    }

    public static void checkDelegateType(Decorator<?> decorator) {
        Set<Type> types = new HierarchyDiscovery(decorator.getDelegateType()).getTypeClosure();
        for (Type decoratedType : decorator.getDecoratedTypes()) {
            if (types.contains(decoratedType)) continue;
            throw new DefinitionException(BeanMessage.DELEGATE_MUST_SUPPORT_EVERY_DECORATED_TYPE, decoratedType, decorator);
        }
    }

    public static <T> void checkAbstractMethods(Set<Type> decoratedTypes, EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        if (decoratedTypes == null) {
            decoratedTypes = new HashSet<Type>(type.getInterfaceClosure());
            decoratedTypes.remove(Serializable.class);
        }
        HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
        for (Type type2 : decoratedTypes) {
            for (EnhancedAnnotatedMethod method : ClassTransformer.instance(beanManager).getEnhancedAnnotatedType(Reflections.getRawType(type2)).getEnhancedMethods()) {
                signatures.add(method.getSignature());
            }
        }
        for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : type.getEnhancedMethods()) {
            MethodSignature methodSignature;
            if (!Reflections.isAbstract(enhancedAnnotatedMethod.getJavaMember()) || signatures.contains(methodSignature = enhancedAnnotatedMethod.getSignature())) continue;
            throw new DefinitionException(BeanMessage.ABSTRACT_METHOD_MUST_MATCH_DECORATED_TYPE, enhancedAnnotatedMethod.getSignature(), type);
        }
    }

    public static boolean isPassivationCapable(Decorator<?> decorator) {
        if (decorator instanceof CustomDecoratorWrapper) {
            decorator = ((CustomDecoratorWrapper)Reflections.cast(decorator)).delegate();
        }
        if (decorator instanceof DecoratorImpl) {
            DecoratorImpl weldDecorator = (DecoratorImpl)decorator;
            return weldDecorator.getEnhancedAnnotated().isSerializable();
        }
        return decorator instanceof PassivationCapable;
    }
}

