/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.bean.AbstractSyntheticBean;
import org.jboss.weld.manager.BeanManagerImpl;

public class SyntheticClassBean<T>
extends AbstractSyntheticBean<T> {
    protected final InjectionTarget<T> producer;

    public SyntheticClassBean(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTarget<T> producer, BeanManagerImpl manager) {
        super(attributes, SyntheticClassBean.createId(attributes, beanClass, producer), manager, beanClass, producer);
        this.producer = producer;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.producer.produce(creationalContext);
        this.producer.inject(instance, creationalContext);
        this.producer.postConstruct(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.producer.preDestroy(instance);
            this.producer.dispose(instance);
        }
        finally {
            creationalContext.release();
        }
    }

    @Override
    public String toString() {
        return "SyntheticClassBean [attributes=" + this.attributes() + ", injectionTarget=" + this.producer + ", beanClass=" + this.getBeanClass() + "]";
    }
}

