/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.ForwardingBeanManager;
import org.jboss.weld.util.reflection.Reflections;

public class BeanManagerProxy
extends ForwardingBeanManager {
    private static final long serialVersionUID = -6990849486568169846L;
    private final BeanManagerImpl manager;
    private volatile transient Container container;

    public BeanManagerProxy(BeanManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public BeanManagerImpl delegate() {
        return this.manager;
    }

    @Override
    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> ctx) {
        this.checkContainerInitialized("getReference()", new ContainerState[0]);
        return super.getReference(bean, beanType, ctx);
    }

    @Override
    public Object getInjectableReference(InjectionPoint ij, CreationalContext<?> ctx) {
        this.checkContainerInitialized("getInjectableReference()", new ContainerState[0]);
        return super.getInjectableReference(ij, ctx);
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        this.checkContainerInitialized("getBeans()", new ContainerState[0]);
        return super.getBeans(beanType, qualifiers);
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        this.checkContainerInitialized("getBeans()", new ContainerState[0]);
        return super.getBeans(name);
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        this.checkContainerInitialized("getPassivationCapableBean()", new ContainerState[0]);
        return super.getPassivationCapableBean(id);
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        this.checkContainerInitialized("resolve()", new ContainerState[0]);
        return super.resolve(beans);
    }

    @Override
    public void validate(InjectionPoint injectionPoint) {
        this.checkContainerInitialized("validate()", ContainerState.VALIDATED, ContainerState.INITIALIZED);
        super.validate(injectionPoint);
    }

    @Override
    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        this.checkContainerInitialized("resolveObserverMethods()", new ContainerState[0]);
        return super.resolveObserverMethods(event, qualifiers);
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        this.checkContainerInitialized("resolveDecorators()", new ContainerState[0]);
        return super.resolveDecorators(types, qualifiers);
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        this.checkContainerInitialized("resolveInterceptors()", new ContainerState[0]);
        return super.resolveInterceptors(type, interceptorBindings);
    }

    protected Object readResolve() throws ObjectStreamException {
        return new BeanManagerProxy(this.manager);
    }

    private void checkContainerInitialized(String methodName, ContainerState ... allowedStates) {
        if (this.container == null) {
            this.container = Container.instance();
        }
        if (allowedStates == null || allowedStates.length == 0) {
            if (ContainerState.INITIALIZED.equals((Object)this.container.getState())) {
                return;
            }
        } else {
            for (ContainerState state : allowedStates) {
                if (!this.container.getState().equals((Object)state)) continue;
                return;
            }
        }
        throw new IllegalStateException(BeanManagerMessage.METHOD_NOT_AVAILABLE_DURING_INITIALIZATION, methodName);
    }

    public static BeanManagerImpl unwrap(BeanManager manager) {
        if (manager instanceof ForwardingBeanManager) {
            manager = ((ForwardingBeanManager)Reflections.cast(manager)).delegate();
        }
        if (manager instanceof BeanManagerImpl) {
            return (BeanManagerImpl)manager;
        }
        throw new IllegalArgumentException("Unknown BeanManager " + manager);
    }
}

