/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ResourceInjectionPoint;
import org.jboss.weld.injection.producer.AbstractInjectionTarget;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.InterceptorApplyingInstantiator;
import org.jboss.weld.injection.producer.SubclassDecoratorApplyingInstantiator;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;

public class DefaultInjectionTarget<T>
extends AbstractInjectionTarget<T> {
    private final Set<ResourceInjectionPoint<?, ?>> resourceInjectionPoints;

    public DefaultInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        super(type, bean, beanManager);
        ArraySet resourceInjectionPoints = new ArraySet();
        resourceInjectionPoints.addAll((Collection<ResourceInjectionPoint<?, ?>>)InjectionPointFactory.silentInstance().getEjbInjectionPoints(bean, type, beanManager));
        resourceInjectionPoints.addAll((Collection<ResourceInjectionPoint<?, ?>>)InjectionPointFactory.silentInstance().getPersistenceContextInjectionPoints(bean, type, beanManager));
        resourceInjectionPoints.addAll((Collection<ResourceInjectionPoint<?, ?>>)InjectionPointFactory.silentInstance().getPersistenceUnitInjectionPoints(bean, type, beanManager));
        resourceInjectionPoints.addAll((Collection<ResourceInjectionPoint<?, ?>>)InjectionPointFactory.silentInstance().getResourceInjectionPoints(bean, type, beanManager));
        resourceInjectionPoints.addAll((Collection<ResourceInjectionPoint<?, ?>>)InjectionPointFactory.silentInstance().getWebServiceRefInjectionPoints(bean, type, beanManager));
        this.resourceInjectionPoints = WeldCollections.immutableSet(resourceInjectionPoints);
    }

    @Override
    protected Instantiator<T> initInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Set<InjectionPoint> injectionPoints) {
        DefaultInstantiator<T> instantiator = new DefaultInstantiator<T>(type, bean, beanManager);
        injectionPoints.addAll(instantiator.getConstructor().getParameterInjectionPoints());
        return instantiator;
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx) {
        new InjectionContextImpl<T>(this.beanManager, this, this.getType(), instance){

            @Override
            public void proceed() {
                Beans.injectEEFields(DefaultInjectionTarget.this.resourceInjectionPoints, instance, ctx);
                Beans.injectFieldsAndInitializers(instance, ctx, DefaultInjectionTarget.this.beanManager, DefaultInjectionTarget.this.getInjectableFields(), DefaultInjectionTarget.this.getInitializerMethods());
            }
        }.run();
    }

    @Override
    public void postConstruct(T instance) {
        if (this.getInstantiator().hasInterceptorSupport()) {
            InterceptionUtils.executePostConstruct(instance);
        } else {
            super.postConstruct(instance);
        }
    }

    @Override
    public void preDestroy(T instance) {
        if (this.getInstantiator().hasInterceptorSupport()) {
            InterceptionUtils.executePredestroy(instance);
        } else {
            super.preDestroy(instance);
        }
    }

    @Override
    public void dispose(T instance) {
    }

    @Override
    public void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
        boolean hasDecorators;
        super.initializeAfterBeanDiscovery(annotatedType);
        boolean hasInterceptors = this.isInterceptionCandidate() && this.beanManager.getInterceptorModelRegistry().containsKey(this.getType().getJavaClass());
        List<Decorator<?>> decorators = null;
        if (this.getBean() != null && this.isInterceptionCandidate()) {
            decorators = this.beanManager.resolveDecorators(this.getBean().getTypes(), this.getBean().getQualifiers());
        }
        boolean bl = hasDecorators = decorators != null && !decorators.isEmpty();
        if (hasDecorators) {
            this.checkDecoratedMethods(annotatedType, decorators);
        }
        if (hasInterceptors || hasDecorators) {
            if (this.getInstantiator() instanceof DefaultInstantiator) {
                this.setInstantiator(new SubclassedComponentInstantiator<T>(annotatedType, this.getBean(), (DefaultInstantiator)this.getInstantiator(), this.beanManager));
            }
            if (hasDecorators) {
                this.setInstantiator(new SubclassDecoratorApplyingInstantiator(this.getInstantiator(), this.getBean(), decorators));
            }
            if (hasInterceptors) {
                this.setInstantiator(new InterceptorApplyingInstantiator<T>(annotatedType, this.getInstantiator(), this.beanManager));
            }
        }
    }

    public Set<ResourceInjectionPoint<?, ?>> getResourceInjectionPoints() {
        return this.resourceInjectionPoints;
    }
}

