/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.injection.producer.InjectionTargetInitializationContext;
import org.jboss.weld.manager.BeanManagerImpl;

public class InjectionTargetService
extends AbstractBootstrapService {
    private final Validator validator = new Validator();
    private final Container container;
    private final BeanManagerImpl beanManager;
    private final Collection<Producer<?>> producersToValidate = new ConcurrentLinkedQueue();
    private final Collection<InjectionTargetInitializationContext<?>> injectionTargetsToInitialize = new ConcurrentLinkedQueue();

    public InjectionTargetService(BeanManagerImpl beanManager) {
        this.container = Container.instance();
        this.beanManager = beanManager;
    }

    public void validateProducer(Producer<?> producer) {
        if (this.container.getState().equals((Object)ContainerState.VALIDATED) || this.container.getState().equals((Object)ContainerState.INITIALIZED)) {
            this.validator.validateProducer(producer, this.beanManager);
        } else {
            for (InjectionPoint ip : producer.getInjectionPoints()) {
                this.validator.validateInjectionPointForDefinitionErrors(ip, ip.getBean(), this.beanManager, false);
            }
            this.producersToValidate.add(producer);
        }
    }

    public void addInjectionTargetToBeInitialized(InjectionTargetInitializationContext<?> initializationContext) {
        if (this.container.getState().equals((Object)ContainerState.VALIDATED) || this.container.getState().equals((Object)ContainerState.INITIALIZED)) {
            initializationContext.initialize();
        } else {
            this.injectionTargetsToInitialize.add(initializationContext);
        }
    }

    public void initialize() {
        for (InjectionTargetInitializationContext<?> initializationContext : this.injectionTargetsToInitialize) {
            initializationContext.initialize();
        }
        this.injectionTargetsToInitialize.clear();
    }

    public void validate() {
        this.validator.validateProducers(this.producersToValidate, this.beanManager);
        this.producersToValidate.clear();
    }

    @Override
    public void cleanupAfterBoot() {
        this.producersToValidate.clear();
        this.injectionTargetsToInitialize.clear();
    }
}

