/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.interceptor.CustomInterceptorMetadata;
import org.jboss.weld.bean.interceptor.SerializableContextualInterceptorReference;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.interceptor.builder.InterceptionModelBuilder;
import org.jboss.weld.interceptor.builder.InterceptorsApiAbstraction;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptionModelInitializer<T> {
    private static final InterceptorMetadata<?>[] EMPTY_INTERCEPTOR_METADATA_ARRAY = new InterceptorMetadata[0];
    private final BeanManagerImpl manager;
    private final EnhancedAnnotatedType<T> annotatedType;
    private final Set<Class<? extends Annotation>> stereotypes;
    private final InterceptorsApiAbstraction interceptorsApi;
    private final EJBApiAbstraction ejbApi;
    private Map<Interceptor<?>, InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>>> interceptorMetadatas = new HashMap();
    private List<AnnotatedMethod<?>> businessMethods;
    private final InterceptionModelBuilder<ClassMetadata<?>, ?> builder;
    private boolean hasSerializationOrInvocationInterceptorMethods;

    private static <T> InterceptorMetadata<T>[] emptyInterceptorMetadataArray() {
        return (InterceptorMetadata[])Reflections.cast(EMPTY_INTERCEPTOR_METADATA_ARRAY);
    }

    public static <T> InterceptionModelInitializer<T> of(BeanManagerImpl manager, EnhancedAnnotatedType<T> annotatedType, Bean<?> bean) {
        return new InterceptionModelInitializer<T>(manager, annotatedType, bean);
    }

    public InterceptionModelInitializer(BeanManagerImpl manager, EnhancedAnnotatedType<T> annotatedType, Bean<?> bean) {
        this.manager = manager;
        this.annotatedType = annotatedType;
        this.builder = InterceptionModelBuilder.newBuilderFor(this.getClassMetadata());
        this.stereotypes = bean == null ? Collections.emptySet() : bean.getStereotypes();
        this.interceptorsApi = manager.getServices().get(InterceptorsApiAbstraction.class);
        this.ejbApi = manager.getServices().get(EJBApiAbstraction.class);
    }

    public void init() {
        this.initTargetClassInterceptors();
        this.businessMethods = Beans.getInterceptableMethods(this.annotatedType);
        this.initEjbInterceptors();
        this.initCdiInterceptors();
        InterceptionModel<ClassMetadata<?>, ?> interceptionModel = this.builder.build();
        if (interceptionModel.getAllInterceptors().size() > 0 || this.hasSerializationOrInvocationInterceptorMethods) {
            if (this.annotatedType.isFinal()) {
                throw new DefinitionException(BeanMessage.FINAL_BEAN_CLASS_WITH_INTERCEPTORS_NOT_ALLOWED, this.annotatedType.getJavaClass());
            }
            this.manager.getInterceptorModelRegistry().put(this.annotatedType.getJavaClass(), interceptionModel);
        }
    }

    private void initTargetClassInterceptors() {
        InterceptorMetadata<T> interceptorClassMetadata;
        this.hasSerializationOrInvocationInterceptorMethods = !Beans.isInterceptor(this.annotatedType) ? (interceptorClassMetadata = this.manager.getInterceptorMetadataReader().getTargetClassInterceptorMetadata(WeldInterceptorClassMetadata.of(this.annotatedType))).isEligible(InterceptionType.AROUND_INVOKE) || interceptorClassMetadata.isEligible(InterceptionType.AROUND_TIMEOUT) || interceptorClassMetadata.isEligible(InterceptionType.PRE_PASSIVATE) || interceptorClassMetadata.isEligible(InterceptionType.POST_ACTIVATE) : false;
    }

    private ClassMetadata<T> getClassMetadata() {
        return this.manager.getInterceptorMetadataReader().getClassMetadata(this.annotatedType.getJavaClass());
    }

    private void initCdiInterceptors() {
        Map<Class<? extends Annotation>, Annotation> classBindingAnnotations = this.getClassInterceptorBindings();
        this.initCdiLifecycleInterceptors(classBindingAnnotations);
        this.initCdiBusinessMethodInterceptors(classBindingAnnotations);
    }

    private Map<Class<? extends Annotation>, Annotation> getClassInterceptorBindings() {
        return Interceptors.mergeBeanInterceptorBindings(this.manager, this.annotatedType, this.stereotypes);
    }

    private void initCdiLifecycleInterceptors(Map<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        if (classBindingAnnotations.size() == 0) {
            return;
        }
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_CONSTRUCT, classBindingAnnotations);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_DESTROY, classBindingAnnotations);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_PASSIVATE, classBindingAnnotations);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_ACTIVATE, classBindingAnnotations);
    }

    private void initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, Map<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        List<Interceptor<?>> resolvedInterceptors = this.manager.resolveInterceptors(interceptionType, classBindingAnnotations.values());
        if (!resolvedInterceptors.isEmpty()) {
            this.builder.intercept(interceptionType).with(this.toSerializableContextualArray(resolvedInterceptors));
        }
    }

    private void initCdiBusinessMethodInterceptors(Map<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        for (AnnotatedMethod<?> method : this.businessMethods) {
            this.initCdiBusinessMethodInterceptor(method, this.getMethodBindingAnnotations(classBindingAnnotations, method));
        }
    }

    private Collection<Annotation> getMethodBindingAnnotations(Map<Class<? extends Annotation>, Annotation> classBindingAnnotations, AnnotatedMethod<?> method) {
        Set<Annotation> methodBindingAnnotations = Interceptors.flattenInterceptorBindings(this.manager, Interceptors.filterInterceptorBindings(this.manager, method.getAnnotations()), true, true);
        return this.mergeMethodInterceptorBindings(classBindingAnnotations, methodBindingAnnotations).values();
    }

    private void initCdiBusinessMethodInterceptor(AnnotatedMethod<?> method, Collection<Annotation> methodBindingAnnotations) {
        if (methodBindingAnnotations.size() == 0) {
            return;
        }
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE, method, methodBindingAnnotations);
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT, method, methodBindingAnnotations);
    }

    private void initInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, AnnotatedMethod<?> method, Collection<Annotation> methodBindingAnnotations) {
        List<Interceptor<?>> methodBoundInterceptors = this.manager.resolveInterceptors(interceptionType, methodBindingAnnotations);
        if (methodBoundInterceptors != null && methodBoundInterceptors.size() > 0) {
            if (Reflections.isFinal(method.getJavaMember())) {
                throw new DefinitionException(BeanMessage.FINAL_INTERCEPTED_BEAN_METHOD_NOT_ALLOWED, method, methodBoundInterceptors.get(0).getBeanClass().getName());
            }
            Method javaMethod = ((AnnotatedMethod)Reflections.cast(method)).getJavaMember();
            this.builder.intercept(interceptionType, javaMethod).with(this.toSerializableContextualArray(methodBoundInterceptors));
        }
    }

    private void initEjbInterceptors() {
        this.initClassDeclaredEjbInterceptors();
        for (AnnotatedMethod<?> method : this.businessMethods) {
            this.initMethodDeclaredEjbInterceptors(method);
        }
    }

    private void initClassDeclaredEjbInterceptors() {
        Class<?>[] classDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses(this.annotatedType);
        if (classDeclaredInterceptors != null) {
            for (Class<?> clazz : classDeclaredInterceptors) {
                this.builder.interceptAll().with(this.manager.getInterceptorMetadataReader().getInterceptorMetadata(clazz));
            }
        }
    }

    private void initMethodDeclaredEjbInterceptors(AnnotatedMethod<?> method) {
        Class<?>[] methodDeclaredInterceptors;
        Method javaMethod = ((AnnotatedMethod)Reflections.cast(method)).getJavaMember();
        boolean excludeClassInterceptors = method.isAnnotationPresent(this.interceptorsApi.getExcludeClassInterceptorsAnnotationClass());
        if (excludeClassInterceptors) {
            this.builder.ignoreGlobalInterceptors(javaMethod);
        }
        if ((methodDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses(method)) != null && methodDeclaredInterceptors.length > 0) {
            if (Reflections.isFinal(method.getJavaMember())) {
                throw new DefinitionException(BeanMessage.FINAL_INTERCEPTED_BEAN_METHOD_NOT_ALLOWED, method, methodDeclaredInterceptors[0].getName());
            }
            javax.enterprise.inject.spi.InterceptionType interceptionType = this.isTimeoutAnnotationPresentOn(method) ? javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT : javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE;
            InterceptorMetadata[] interceptors = this.getMethodDeclaredInterceptorMetadatas(methodDeclaredInterceptors);
            this.builder.intercept(interceptionType, javaMethod).with(interceptors);
        }
    }

    private InterceptorMetadata<?>[] getMethodDeclaredInterceptorMetadatas(Class<?>[] methodDeclaredInterceptors) {
        ArrayList list = new ArrayList();
        for (Class<?> clazz : methodDeclaredInterceptors) {
            list.add(this.manager.getInterceptorMetadataReader().getInterceptorMetadata(clazz));
        }
        return list.toArray(new InterceptorMetadata[list.size()]);
    }

    private boolean isTimeoutAnnotationPresentOn(AnnotatedMethod<?> method) {
        return method.isAnnotationPresent(this.ejbApi.TIMEOUT_ANNOTATION_CLASS);
    }

    private InterceptorMetadata<SerializableContextual<?, ?>>[] toSerializableContextualArray(List<Interceptor<?>> interceptors) {
        ArrayList serializableContextuals = new ArrayList();
        for (Interceptor<?> interceptor : interceptors) {
            serializableContextuals.add(this.getCachedInterceptorMetadata(interceptor));
        }
        return serializableContextuals.toArray(InterceptionModelInitializer.emptyInterceptorMetadataArray());
    }

    private InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> getCachedInterceptorMetadata(Interceptor<?> interceptor) {
        InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> interceptorMetadata = this.interceptorMetadatas.get(interceptor);
        if (interceptorMetadata == null) {
            interceptorMetadata = this.getInterceptorMetadata(interceptor);
            this.interceptorMetadatas.put(interceptor, interceptorMetadata);
        }
        return interceptorMetadata;
    }

    private InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> getInterceptorMetadata(Interceptor<?> interceptor) {
        ContextualStore store = this.manager.getServices().get(ContextualStore.class);
        SerializableContextual contextual = (SerializableContextual)Reflections.cast(store.getSerializableContextual(interceptor));
        if (interceptor instanceof InterceptorImpl) {
            InterceptorImpl interceptorImpl = (InterceptorImpl)interceptor;
            ClassMetadata<?> classMetadata = interceptorImpl.getInterceptorMetadata().getInterceptorClass();
            SerializableContextualInterceptorReference interceptorReference = new SerializableContextualInterceptorReference(contextual, classMetadata);
            return this.manager.getInterceptorMetadataReader().getInterceptorMetadata(interceptorReference);
        }
        ClassMetadata<?> classMetadata = this.manager.getInterceptorMetadataReader().getClassMetadata(interceptor.getBeanClass());
        return new CustomInterceptorMetadata(new SerializableContextualInterceptorReference(contextual, null), classMetadata);
    }

    protected Map<Class<? extends Annotation>, Annotation> mergeMethodInterceptorBindings(Map<Class<? extends Annotation>, Annotation> beanBindings, Collection<Annotation> methodBindingAnnotations) {
        HashMap<Class<? extends Annotation>, Annotation> mergedBeanBindings = new HashMap<Class<? extends Annotation>, Annotation>(beanBindings);
        HashSet<Class<? extends Annotation>> processedBindingTypes = new HashSet<Class<? extends Annotation>>();
        for (Annotation methodBinding : methodBindingAnnotations) {
            Class<? extends Annotation> methodBindingType = methodBinding.annotationType();
            if (processedBindingTypes.contains(methodBindingType)) {
                throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.annotatedType);
            }
            processedBindingTypes.add(methodBindingType);
            mergedBeanBindings.put(methodBindingType, methodBinding);
        }
        return mergedBeanBindings;
    }
}

