/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer.ejb;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.DynamicInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.producer.AbstractInjectionTarget;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.SubclassDecoratorApplyingInstantiator;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;

public class SessionBeanInjectionTarget<T>
extends AbstractInjectionTarget<T> {
    private final SessionBean<T> bean;
    private final CurrentInjectionPoint currentInjectionPoint;

    public SessionBeanInjectionTarget(EnhancedAnnotatedType<T> type, SessionBean<T> bean, BeanManagerImpl beanManager) {
        super(type, bean, beanManager);
        this.bean = bean;
        this.currentInjectionPoint = beanManager.getServices().get(CurrentInjectionPoint.class);
    }

    @Override
    public SessionBean<T> getBean() {
        return this.bean;
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx) {
        new InjectionContextImpl<T>(this.getBeanManager(), this, this.getType(), instance){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void proceed() {
                if (this.isStatelessSessionBean()) {
                    SessionBeanInjectionTarget.this.currentInjectionPoint.push(new DynamicInjectionPoint(SessionBeanInjectionTarget.this.beanManager.getServices()));
                    try {
                        this.injectFieldsAndInitializers();
                    }
                    finally {
                        SessionBeanInjectionTarget.this.currentInjectionPoint.pop();
                    }
                } else {
                    this.injectFieldsAndInitializers();
                }
            }

            private boolean isStatelessSessionBean() {
                return ((SessionBean)SessionBeanInjectionTarget.this.getBean()).getEjbDescriptor().isStateless();
            }

            private void injectFieldsAndInitializers() {
                Beans.injectFieldsAndInitializers(instance, ctx, SessionBeanInjectionTarget.this.getBeanManager(), SessionBeanInjectionTarget.this.getInjectableFields(), SessionBeanInjectionTarget.this.getInitializerMethods());
            }
        }.run();
    }

    @Override
    protected Instantiator<T> initInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Set<InjectionPoint> injectionPoints) {
        if (bean instanceof SessionBean) {
            DefaultInstantiator<T> instantiator = new DefaultInstantiator<T>(type, bean, beanManager);
            injectionPoints.addAll(instantiator.getConstructor().getParameterInjectionPoints());
            return instantiator;
        }
        throw new IllegalArgumentException("Cannot create SessionBeanInjectionTarget for " + bean);
    }

    @Override
    protected void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
        super.initializeAfterBeanDiscovery(annotatedType);
        List<Decorator<?>> decorators = this.beanManager.resolveDecorators(((ForwardingBeanAttributes)((Object)this.getBean())).getTypes(), ((ForwardingBeanAttributes)((Object)this.getBean())).getQualifiers());
        if (!decorators.isEmpty()) {
            Instantiator instantiator = this.getInstantiator();
            instantiator = new SubclassedComponentInstantiator<T>(annotatedType, this.getBean(), (DefaultInstantiator)instantiator, this.beanManager);
            instantiator = new SubclassDecoratorApplyingInstantiator(instantiator, this.getBean(), decorators);
            this.setInstantiator(instantiator);
        }
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        T result = super.produce(ctx);
        if (result instanceof ProxyObject) {
            ProxyObject proxy = (ProxyObject)result;
            proxy.setHandler(new SessionBeanViewMethodHandler(this.bean.getTypes(), (CombinedInterceptorAndDecoratorStackMethodHandler)proxy.getHandler()));
        }
        return result;
    }

    private static class SessionBeanViewMethodHandler
    extends CombinedInterceptorAndDecoratorStackMethodHandler {
        private static final long serialVersionUID = -8038819529432133787L;
        private final Set<Class<?>> beanTypes;

        public SessionBeanViewMethodHandler(Set<Type> types, CombinedInterceptorAndDecoratorStackMethodHandler delegate) {
            this.beanTypes = Types.getRawTypes(types);
            this.setOuterDecorator(delegate.getOuterDecorator());
            this.setInterceptorMethodHandler(delegate.getInterceptorMethodHandler());
        }

        @Override
        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (this.beanTypes.contains(thisMethod.getDeclaringClass())) {
                return super.invoke(self, thisMethod, proceed, args);
            }
            Method decoratedTypeMethod = this.getBeanTypeMethod(thisMethod);
            return super.invoke(self, decoratedTypeMethod, proceed, args);
        }

        private Method getBeanTypeMethod(Method method) {
            for (Class<?> c : this.beanTypes) {
                try {
                    return c.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                }
            }
            return method;
        }
    }
}

