/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.spi.helpers;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceServices
implements Service,
ResourceInjectionServices {
    private static final String RESOURCE_LOOKUP_PREFIX = "java:comp/env";

    @Override
    public Object resolveResource(InjectionPoint injectionPoint) {
        if (!injectionPoint.getAnnotated().isAnnotationPresent(Resource.class)) {
            throw new IllegalArgumentException("No @Resource annotation found on injection point " + injectionPoint);
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + injectionPoint);
        }
        String name = this.getResourceName(injectionPoint);
        try {
            return this.getContext().lookup(name);
        }
        catch (NamingException e) {
            throw new RuntimeException("Error looking up " + name + " in JNDI", e);
        }
    }

    @Override
    public Object resolveResource(String jndiName, String mappedName) {
        String name = this.getResourceName(jndiName, mappedName);
        try {
            return this.getContext().lookup(name);
        }
        catch (NamingException e) {
            throw new RuntimeException("Error looking up " + name + " in JNDI", e);
        }
    }

    protected String getResourceName(String jndiName, String mappedName) {
        if (mappedName != null) {
            return mappedName;
        }
        if (jndiName != null) {
            return jndiName;
        }
        throw new IllegalArgumentException("Both jndiName and mappedName are null");
    }

    protected abstract Context getContext();

    protected String getResourceName(InjectionPoint injectionPoint) {
        String propertyName;
        Resource resource = injectionPoint.getAnnotated().getAnnotation(Resource.class);
        String mappedName = resource.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = resource.name();
        if (!name.equals("")) {
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = AbstractResourceServices.getPropertyName((Method)injectionPoint.getMember());
            if (propertyName == null) {
                throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (unable to determine property name) " + injectionPoint);
            }
        } else {
            throw new AssertionError((Object)("Unable to inject into " + injectionPoint));
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    @Override
    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(final InjectionPoint injectionPoint) {
        return new ResourceReferenceFactory<Object>(){

            @Override
            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference<Object>(AbstractResourceServices.this.resolveResource(injectionPoint));
            }
        };
    }

    @Override
    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(final String jndiName, final String mappedName) {
        return new ResourceReferenceFactory<Object>(){

            @Override
            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference<Object>(AbstractResourceServices.this.resolveResource(jndiName, mappedName));
            }
        };
    }

    @Override
    public void cleanup() {
    }
}

