/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class Observers {
    public static final Set<Class<?>> CONTAINER_LIFECYCLE_EVENT_TYPES;
    public static final Set<Class<?>> CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES;

    public static boolean isContainerLifecycleObserverMethod(ObserverMethod<?> method) {
        return CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(method.getObservedType())) || Object.class.equals((Object)method.getObservedType()) && method instanceof ExtensionObserverMethodImpl;
    }

    public static boolean isObserverMethodEnabled(ObserverMethod<?> method, BeanManagerImpl manager) {
        if (method instanceof ObserverMethodImpl) {
            RIBean declaringBean = ((ObserverMethodImpl)Reflections.cast(method)).getDeclaringBean();
            return manager.getServices().get(SpecializationAndEnablementRegistry.class).isCandidateForLifecycleEvent(declaringBean);
        }
        return true;
    }

    static {
        HashSet<Class> types = new HashSet<Class>();
        types.add(BeforeBeanDiscovery.class);
        types.add(AfterBeanDiscovery.class);
        types.add(AfterDeploymentValidation.class);
        types.add(BeforeShutdown.class);
        types.add(ProcessAnnotatedType.class);
        types.add(ProcessSyntheticAnnotatedType.class);
        types.add(ProcessInjectionPoint.class);
        types.add(ProcessInjectionTarget.class);
        types.add(ProcessProducer.class);
        types.add(ProcessBeanAttributes.class);
        types.add(ProcessBean.class);
        types.add(ProcessSessionBean.class);
        types.add(ProcessManagedBean.class);
        types.add(ProcessProducerMethod.class);
        types.add(ProcessProducerField.class);
        types.add(ProcessObserverMethod.class);
        CONTAINER_LIFECYCLE_EVENT_TYPES = Collections.unmodifiableSet(types);
        HashSet<Class<ProcessObserverMethod>> canonicalSupertypes = new HashSet<Class<ProcessObserverMethod>>();
        canonicalSupertypes.add(BeforeBeanDiscovery.class);
        canonicalSupertypes.add(AfterBeanDiscovery.class);
        canonicalSupertypes.add(AfterDeploymentValidation.class);
        canonicalSupertypes.add(BeforeShutdown.class);
        canonicalSupertypes.add(ProcessAnnotatedType.class);
        canonicalSupertypes.add(ProcessInjectionPoint.class);
        canonicalSupertypes.add(ProcessInjectionTarget.class);
        canonicalSupertypes.add(ProcessProducer.class);
        canonicalSupertypes.add(ProcessBeanAttributes.class);
        canonicalSupertypes.add(ProcessBean.class);
        canonicalSupertypes.add(ProcessObserverMethod.class);
        CONTAINER_LIFECYCLE_EVENT_CANONICAL_SUPERTYPES = Collections.unmodifiableSet(canonicalSupertypes);
    }
}

