/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.Producer;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.executor.IterativeWorkerTaskFactory;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.HashSetSupplier;

public class ConcurrentValidator
extends Validator {
    private final ExecutorServices executor;

    public ConcurrentValidator(ExecutorServices executor) {
        this.executor = executor;
    }

    @Override
    public void validateBeans(Collection<? extends Bean<?>> beans, final BeanManagerImpl manager) {
        final CopyOnWriteArrayList problems = new CopyOnWriteArrayList();
        final Set specializedBeans = Sets.newSetFromMap(new ConcurrentHashMap());
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<Bean<?>>(beans){

            @Override
            protected void doWork(Bean<?> bean) {
                ConcurrentValidator.this.validateBean(bean, specializedBeans, manager, problems);
            }
        });
        if (!problems.isEmpty()) {
            if (problems.size() == 1) {
                throw (RuntimeException)problems.get(0);
            }
            throw new DeploymentException(problems);
        }
    }

    @Override
    public void validateInterceptors(Collection<? extends Interceptor<?>> interceptors, final BeanManagerImpl manager) {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<Interceptor<?>>(interceptors){

            @Override
            protected void doWork(Interceptor<?> interceptor) {
                ConcurrentValidator.this.validateInterceptor(interceptor, manager);
            }
        });
    }

    @Override
    public void validateDecorators(Collection<? extends Decorator<?>> decorators, final BeanManagerImpl manager) {
        final Set specializedBeans = Sets.newSetFromMap(new ConcurrentHashMap());
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<Decorator<?>>(decorators){

            @Override
            protected void doWork(Decorator<?> decorator) {
                ConcurrentValidator.this.validateDecorator(decorator, specializedBeans, manager);
            }
        });
    }

    @Override
    protected void validateObserverMethods(Iterable<ObserverInitializationContext<?, ?>> observers, final BeanManagerImpl beanManager) {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<ObserverInitializationContext<?, ?>>(observers){

            @Override
            protected void doWork(ObserverInitializationContext<?, ?> observerMethod) {
                for (InjectionPoint injectionPoint : observerMethod.getObserver().getInjectionPoints()) {
                    ConcurrentValidator.this.validateInjectionPointForDefinitionErrors(injectionPoint, injectionPoint.getBean(), beanManager, true);
                    ConcurrentValidator.this.validateInjectionPointForDeploymentProblems(injectionPoint, injectionPoint.getBean(), beanManager);
                }
            }
        });
    }

    @Override
    public void validateBeanNames(final BeanManagerImpl beanManager) {
        final SetMultimap namedAccessibleBeans = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        for (Bean<?> bean : beanManager.getAccessibleBeans()) {
            if (bean.getName() == null) continue;
            namedAccessibleBeans.put(bean.getName(), bean);
        }
        final ArrayList<String> accessibleNamespaces = new ArrayList<String>();
        for (String namespace : beanManager.getAccessibleNamespaces()) {
            accessibleNamespaces.add(namespace);
        }
        final SpecializationAndEnablementRegistry registry = beanManager.getServices().get(SpecializationAndEnablementRegistry.class);
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<String>(namedAccessibleBeans.keySet()){

            @Override
            protected void doWork(String name) {
                Set resolvedBeans = beanManager.getBeanResolver().resolve(Beans.removeDisabledAndSpecializedBeans(namedAccessibleBeans.get(name), beanManager, registry));
                if (resolvedBeans.size() > 1) {
                    throw new DeploymentException(ValidatorMessage.AMBIGUOUS_EL_NAME, name, resolvedBeans);
                }
                if (accessibleNamespaces.contains(name)) {
                    throw new DeploymentException(ValidatorMessage.BEAN_NAME_IS_PREFIX, name);
                }
            }
        });
    }

    @Override
    public void validateProducers(Collection<Producer<?>> producers, final BeanManagerImpl beanManager) {
        this.executor.invokeAllAndCheckForExceptions(new IterativeWorkerTaskFactory<Producer<?>>(producers){

            @Override
            protected void doWork(Producer<?> producer) {
                ConcurrentValidator.this.validateProducer(producer, beanManager);
            }
        });
    }
}

