/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractBeanDiscoveryEvent;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.bean.IsolatedForwardingBean;
import org.jboss.weld.util.bean.IsolatedForwardingDecorator;
import org.jboss.weld.util.bean.IsolatedForwardingInterceptor;
import org.jboss.weld.util.bean.WrappedBeanHolder;
import org.jboss.weld.util.reflection.Reflections;

public class AfterBeanDiscoveryImpl
extends AbstractBeanDiscoveryEvent
implements AfterBeanDiscovery {
    private final SlimAnnotatedTypeStore slimAnnotatedTypeStore;

    public static void fire(BeanManagerImpl beanManager, Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Collection<ContextHolder<? extends Context>> contexts) {
        new AfterBeanDiscoveryImpl(beanManager, deployment, beanDeployments, contexts).fire();
    }

    protected AfterBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)AfterBeanDiscovery.class), beanDeployments, deployment, contexts);
        this.slimAnnotatedTypeStore = beanManager.getServices().get(SlimAnnotatedTypeStore.class);
    }

    @Override
    public void addDefinitionError(Throwable t) {
        this.getErrors().add(t);
    }

    public List<Throwable> getDefinitionErrors() {
        return Collections.unmodifiableList(this.getErrors());
    }

    @Override
    public void addBean(Bean<?> bean) {
        this.processBean(bean);
    }

    protected <T> void processBean(Bean<T> b) {
        Bean<T> bean = b;
        BeanManagerImpl beanManager = this.getOrCreateBeanDeployment(bean.getBeanClass()).getBeanManager();
        ExternalBeanAttributesFactory.validateBeanAttributes(bean, beanManager);
        ContainerLifecycleEvents containerLifecycleEvents = beanManager.getServices().get(ContainerLifecycleEvents.class);
        if (bean instanceof Interceptor) {
            beanManager.addInterceptor((Interceptor)bean);
        } else if (bean instanceof Decorator) {
            beanManager.addDecorator(CustomDecoratorWrapper.of((Decorator)bean, beanManager));
        } else {
            beanManager.addBean(bean);
        }
        containerLifecycleEvents.fireProcessBean(beanManager, bean);
    }

    @Override
    public void addContext(Context context) {
        this.getBeanManager().addContext(context);
    }

    @Override
    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        BeanManagerImpl manager = this.getOrCreateBeanDeployment(observerMethod.getBeanClass()).getBeanManager();
        if (Observers.isObserverMethodEnabled(observerMethod, manager)) {
            ProcessObserverMethodImpl.fire(manager, observerMethod);
            manager.addObserver(observerMethod);
        }
        this.getOrCreateBeanDeployment(observerMethod.getBeanClass()).getBeanManager().addObserver(observerMethod);
    }

    private <T> Bean<T> setBeanAttributes(Bean<T> bean, BeanAttributes<T> attributes) {
        if (bean instanceof Interceptor) {
            return new IsolatedForwardingInterceptor.Impl<T>(WrappedBeanHolder.of(attributes, (Interceptor)bean));
        }
        if (bean instanceof Decorator) {
            return new IsolatedForwardingDecorator.Impl<T>(WrappedBeanHolder.of(attributes, (Decorator)bean));
        }
        return new IsolatedForwardingBean.Impl<T>(WrappedBeanHolder.of(attributes, bean));
    }

    @Override
    public <T> AnnotatedType<T> getAnnotatedType(Class<T> type, String id) {
        Preconditions.checkArgumentNotNull(type, "type");
        return this.slimAnnotatedTypeStore.get(type, id);
    }

    @Override
    public <T> Iterable<AnnotatedType<T>> getAnnotatedTypes(Class<T> type) {
        Preconditions.checkArgumentNotNull(type, "type");
        return (Iterable)Reflections.cast(this.slimAnnotatedTypeStore.get(type));
    }
}

