/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptionContext
implements Serializable {
    private static final Set<InterceptionType> CONSTRUCTOR_INTERCEPTION_TYPES = ImmutableSet.of(InterceptionType.AROUND_CONSTRUCT);
    private static final Set<InterceptionType> METHOD_INTERCEPTION_TYPES = ImmutableSet.of(InterceptionType.AROUND_INVOKE, InterceptionType.AROUND_TIMEOUT, InterceptionType.POST_CONSTRUCT, InterceptionType.PRE_DESTROY, InterceptionType.POST_ACTIVATE, InterceptionType.PRE_PASSIVATE, new InterceptionType[0]);
    private static final long serialVersionUID = 7500722360133273633L;
    private final transient TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata;
    private final transient InterceptionModel<ClassMetadata<?>, ?> interceptionModel;
    private final Map<Class<?>, Object> interceptorInstances;
    private final BeanManagerImpl manager;
    private final Class<?> targetClass;

    public static InterceptionContext forConstructorInterception(InterceptionModel<ClassMetadata<?>, ?> interceptionModel, CreationalContext<?> ctx, BeanManagerImpl manager) {
        return InterceptionContext.of(interceptionModel, ctx, manager, CONSTRUCTOR_INTERCEPTION_TYPES);
    }

    public static InterceptionContext forNonConstructorInterception(InterceptionModel<ClassMetadata<?>, ?> interceptionModel, CreationalContext<?> ctx, BeanManagerImpl manager) {
        return InterceptionContext.of(interceptionModel, ctx, manager, METHOD_INTERCEPTION_TYPES);
    }

    private static InterceptionContext of(InterceptionModel<ClassMetadata<?>, ?> interceptionModel, CreationalContext<?> ctx, BeanManagerImpl manager, Set<InterceptionType> interceptionTypes) {
        TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata = manager.getInterceptorMetadataReader().getTargetClassInterceptorMetadata(interceptionModel.getInterceptedEntity());
        return new InterceptionContext(InterceptionContext.initInterceptorInstanceMap(interceptionModel, ctx, manager, interceptionTypes), manager, targetClassInterceptorMetadata, interceptionModel);
    }

    private InterceptionContext(Map<Class<?>, Object> interceptorInstances, BeanManagerImpl manager, TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata, InterceptionModel<ClassMetadata<?>, ?> interceptionModel) {
        this.interceptorInstances = interceptorInstances;
        this.manager = manager;
        this.targetClassInterceptorMetadata = targetClassInterceptorMetadata;
        this.interceptionModel = interceptionModel;
        this.targetClass = targetClassInterceptorMetadata.getInterceptorClass().getJavaClass();
    }

    private static Map<Class<?>, Object> initInterceptorInstanceMap(InterceptionModel<?, ?> model, CreationalContext ctx, BeanManagerImpl manager, Set<InterceptionType> interceptionTypes) {
        HashMap interceptorInstances = new HashMap();
        for (InterceptorMetadata<?> interceptor : model.getAllInterceptors()) {
            for (InterceptionType interceptionType : interceptionTypes) {
                if (!interceptor.isEligible(interceptionType)) continue;
                interceptorInstances.put(interceptor.getInterceptorClass().getJavaClass(), interceptor.getInterceptorFactory().create(ctx, manager));
            }
        }
        return WeldCollections.immutableMap(interceptorInstances);
    }

    public TargetClassInterceptorMetadata<?> getTargetClassInterceptorMetadata() {
        return this.targetClassInterceptorMetadata;
    }

    public InterceptionModel<ClassMetadata<?>, ?> getInterceptionModel() {
        return this.interceptionModel;
    }

    public <T> T getInterceptorInstance(InterceptorMetadata<T> interceptorMetadata) {
        return Reflections.cast(this.interceptorInstances.get(interceptorMetadata.getInterceptorClass().getJavaClass()));
    }

    private Object readResolve() throws ObjectStreamException {
        InterceptionModel interceptionModel = (InterceptionModel)this.manager.getInterceptorModelRegistry().get(this.targetClass);
        MetadataCachingReader reader = this.manager.getInterceptorMetadataReader();
        TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata = reader.getTargetClassInterceptorMetadata(reader.getClassMetadata(this.targetClass));
        return new InterceptionContext(this.interceptorInstances, this.manager, targetClassInterceptorMetadata, interceptionModel);
    }
}

