/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bean.CommonBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.QualifierInstance;

public abstract class RIBean<T>
extends CommonBean<T>
implements PassivationCapable {
    protected final BeanManagerImpl beanManager;
    private boolean initialized;
    private volatile Set<QualifierInstance> qualifiers;

    protected RIBean(BeanAttributes<T> attributes, String idSuffix, BeanManagerImpl beanManager) {
        super(attributes, idSuffix, beanManager);
        this.beanManager = beanManager;
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public abstract Class<T> getType();

    @Override
    public Class<?> getBeanClass() {
        return this.getType();
    }

    public abstract void preInitialize();

    public final synchronized void initialize(BeanDeployerEnvironment environment) {
        if (!this.initialized) {
            this.internalInitialize(environment);
            this.initialized = true;
        }
    }

    protected abstract void internalInitialize(BeanDeployerEnvironment var1);

    public abstract void cleanupAfterBoot();

    public abstract void initializeAfterBeanDiscovery();

    public boolean isDependent() {
        return this.getScope().equals(Dependent.class);
    }

    public boolean isNormalScoped() {
        return this.getBeanManager().isNormalScope(this.getScope());
    }

    public abstract boolean isProxyable();

    public abstract boolean isPassivationCapableBean();

    public abstract boolean isPassivationCapableDependency();

    public abstract boolean isProxyRequired();

    public Set<QualifierInstance> getQualifierInstances() {
        if (this.qualifiers == null) {
            this.qualifiers = QualifierInstance.qualifiers(this.beanManager, this.getQualifiers());
        }
        return this.qualifiers;
    }
}

