/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import ch.qos.cal10n.IMessageConveyor;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.MessageConveyorFactory;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.cal10n.LocLoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class LoggerFactory {
    private static volatile LoggerFactory INSTANCE;
    private final LocLoggerFactory locLoggerFactory;
    private final IMessageConveyor messageConveyor;

    public static void cleanup() {
        INSTANCE = null;
    }

    private LoggerFactory(String subsystem) {
        this.messageConveyor = MessageConveyorFactory.messageConveyorFactory().getDefaultMessageConveyor(subsystem);
        this.locLoggerFactory = new LocLoggerFactory(this.messageConveyor);
    }

    public LocLogger getLogger(Category category) {
        return this.locLoggerFactory.getLocLogger(category.getName());
    }

    public XLogger getXLogger(Category category) {
        return XLoggerFactory.getXLogger(category.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoggerFactory loggerFactory() {
        if (INSTANCE != null) return INSTANCE;
        Class<LoggerFactory> clazz = LoggerFactory.class;
        synchronized (LoggerFactory.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new LoggerFactory("WELD");
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public IMessageConveyor getMessageConveyor() {
        return this.messageConveyor;
    }
}

