/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.Container;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationFilter;
import org.jboss.weld.servlet.HttpContextLifecycle;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;

public class WeldInitialListener
extends AbstractServletListener {
    @Inject
    private BeanManagerImpl beanManager;
    private HttpContextLifecycle lifecycle;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        Container instance;
        String contextId;
        if (this.beanManager == null && (contextId = sce.getServletContext().getInitParameter("WELD_CONTEXT_ID_KEY")) != null && (instance = Container.instance(contextId)).beanDeploymentArchives().size() == 1) {
            this.beanManager = instance.beanDeploymentArchives().values().iterator().next();
        }
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProxy.unwrap(CDI.current().getBeanManager());
        }
        this.lifecycle = new HttpContextLifecycle(this.beanManager);
        if (Boolean.valueOf(sce.getServletContext().getInitParameter(ConversationFilter.CONVERSATION_FILTER_REGISTERED)).booleanValue()) {
            this.lifecycle.setConversationActivationEnabled(false);
        }
        this.lifecycle.contextInitialized(sce.getServletContext());
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.lifecycle.contextDestroyed(sce.getServletContext());
    }

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        this.lifecycle.sessionCreated(event.getSession());
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        this.lifecycle.sessionDestroyed(event.getSession());
    }

    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        if (!(event.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        }
        this.lifecycle.requestDestroyed((HttpServletRequest)event.getServletRequest());
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        Object value;
        if (this.lifecycle.isConversationActivationEnabled() && Boolean.TRUE.equals(value = event.getServletContext().getAttribute(ConversationFilter.CONVERSATION_FILTER_REGISTERED))) {
            this.lifecycle.setConversationActivationEnabled(false);
        }
        if (!(event.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        }
        this.lifecycle.requestInitialized((HttpServletRequest)event.getServletRequest(), event.getServletContext());
    }
}

