/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.bean.builtin.ee.ServletContextBean;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.context.http.HttpSessionDestructionContext;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.ServletLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationContextActivator;
import org.jboss.weld.servlet.SessionHolder;
import org.jboss.weld.servlet.spi.HttpContextActivationFilter;
import org.jboss.weld.util.reflection.Reflections;

public class HttpContextLifecycle
implements Service {
    private static final String HTTP_SESSION = "org.jboss.weld." + HttpSession.class.getName();
    private static final String INCLUDE_HEADER = "javax.servlet.include.request_uri";
    private static final String REQUEST_DESTROYED = HttpContextLifecycle.class.getName() + ".request.destroyed";
    private HttpSessionDestructionContext sessionDestructionContextCache;
    private HttpSessionContext sessionContextCache;
    private HttpRequestContext requestContextCache;
    private volatile Boolean conversationActivationEnabled;
    private final BeanManagerImpl beanManager;
    private final ConversationContextActivator conversationContextActivator;
    private final HttpContextActivationFilter contextActivationFilter;

    public HttpContextLifecycle(BeanManagerImpl beanManager, HttpContextActivationFilter contextActivationFilter) {
        this.beanManager = beanManager;
        this.conversationContextActivator = new ConversationContextActivator(beanManager);
        this.conversationActivationEnabled = null;
        this.contextActivationFilter = contextActivationFilter;
    }

    private HttpSessionDestructionContext getSessionDestructionContext() {
        if (this.sessionDestructionContextCache == null) {
            this.sessionDestructionContextCache = (HttpSessionDestructionContext)this.beanManager.instance().select(HttpSessionDestructionContext.class, new Annotation[0]).get();
        }
        return this.sessionDestructionContextCache;
    }

    private HttpSessionContext getSessionContext() {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)this.beanManager.instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    public HttpRequestContext getRequestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)this.beanManager.instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    public void contextInitialized(ServletContext ctx) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)ctx, new Annotation[]{InitializedLiteral.APPLICATION});
    }

    public void contextDestroyed(ServletContext ctx) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)ctx, new Annotation[]{DestroyedLiteral.APPLICATION});
    }

    public void sessionCreated(HttpSession session) {
        SessionHolder.sessionCreated(session);
        this.conversationContextActivator.sessionCreated(session);
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)session, new Annotation[]{InitializedLiteral.SESSION});
    }

    public void sessionDestroyed(HttpSession session) {
        this.deactivateSessionDestructionContext(session);
        boolean destroyed = this.getSessionContext().destroy(session);
        SessionHolder.clear();
        RequestScopedBeanCache.endRequest();
        if (destroyed) {
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)session, new Annotation[]{DestroyedLiteral.SESSION});
        } else if (this.getRequestContext() instanceof HttpRequestContextImpl) {
            HttpServletRequest request = ((HttpRequestContextImpl)Reflections.cast(this.getRequestContext())).getHttpServletRequest();
            request.setAttribute(HTTP_SESSION, (Object)session);
        }
    }

    private void deactivateSessionDestructionContext(HttpSession session) {
        HttpSessionDestructionContext context = this.getSessionDestructionContext();
        if (context.isActive()) {
            context.deactivate();
            context.dissociate(session);
        }
    }

    public void requestInitialized(HttpServletRequest request, ServletContext ctx) {
        if (this.isIncludedRequest(request)) {
            return;
        }
        if (!this.contextActivationFilter.accepts(request)) {
            return;
        }
        ServletLogger.LOG.requestInitialized(request);
        SessionHolder.requestInitialized(request);
        ServletContextBean.setServletContext(ctx);
        this.getRequestContext().associate(request);
        this.getSessionContext().associate(request);
        if (this.conversationActivationEnabled.booleanValue()) {
            this.conversationContextActivator.associateConversationContext(request);
        }
        this.getRequestContext().activate();
        this.getSessionContext().activate();
        try {
            if (this.conversationActivationEnabled.booleanValue()) {
                this.conversationContextActivator.activateConversationContext(request);
            }
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, new Annotation[]{InitializedLiteral.REQUEST});
        }
        catch (RuntimeException e) {
            try {
                this.requestDestroyed(request);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            request.setAttribute(REQUEST_DESTROYED, (Object)Boolean.TRUE);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(HttpServletRequest request) {
        if (this.isIncludedRequest(request) || this.isRequestDestroyed(request)) {
            return;
        }
        if (!this.contextActivationFilter.accepts(request)) {
            return;
        }
        ServletLogger.LOG.requestDestroyed(request);
        try {
            this.conversationContextActivator.deactivateConversationContext(request);
            this.getRequestContext().invalidate();
            this.getRequestContext().deactivate();
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)request, new Annotation[]{DestroyedLiteral.REQUEST});
            this.getSessionContext().deactivate();
            if (!this.getSessionContext().isValid()) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent(request.getAttribute(HTTP_SESSION), new Annotation[]{DestroyedLiteral.SESSION});
            }
        }
        finally {
            this.getRequestContext().dissociate(request);
            this.getSessionContext().dissociate(request);
            this.conversationContextActivator.disassociateConversationContext(request);
            SessionHolder.clear();
            ServletContextBean.cleanup();
        }
    }

    public boolean isConversationActivationSet() {
        return this.conversationActivationEnabled != null;
    }

    public void setConversationActivationEnabled(boolean conversationActivationEnabled) {
        this.conversationActivationEnabled = conversationActivationEnabled;
    }

    private boolean isIncludedRequest(HttpServletRequest request) {
        return request.getAttribute(INCLUDE_HEADER) != null;
    }

    private boolean isRequestDestroyed(HttpServletRequest request) {
        return request.getAttribute(REQUEST_DESTROYED) != null;
    }

    @Override
    public void cleanup() {
    }
}

