/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.InjectionTargetFactoryImpl;

public class ClassMetadataInterceptorFactory<T>
implements InterceptorFactory<T> {
    private final ClassMetadata<T> classMetadata;
    private final InjectionTarget<T> injectionTarget;

    public static <T> InterceptorFactory<T> of(ClassMetadata<T> classMetadata, BeanManagerImpl manager) {
        return new ClassMetadataInterceptorFactory<T>(classMetadata, manager);
    }

    private ClassMetadataInterceptorFactory(ClassMetadata<T> classMetadata, BeanManagerImpl manager) {
        this.classMetadata = classMetadata;
        this.injectionTarget = ((InjectionTargetFactoryImpl)manager.getInjectionTargetFactory((AnnotatedType)manager.createAnnotatedType(classMetadata.getJavaClass()))).createInterceptorInjectionTarget();
    }

    @Override
    public ClassMetadata<T> getClassMetadata() {
        return this.classMetadata;
    }

    @Override
    public T create(CreationalContext<T> ctx, BeanManagerImpl manager) {
        if (ctx instanceof WeldCreationalContext) {
            WeldCreationalContext weldCtx = (WeldCreationalContext)ctx;
            ctx = weldCtx.getCreationalContext(null);
        }
        Object instance = this.injectionTarget.produce(ctx);
        this.injectionTarget.inject(instance, ctx);
        return (T)instance;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClassMetadataInterceptorFactory) {
            ClassMetadataInterceptorFactory that = (ClassMetadataInterceptorFactory)o;
            return this.classMetadata.equals(that.classMetadata);
        }
        return false;
    }

    public int hashCode() {
        return this.classMetadata.hashCode();
    }

    public String toString() {
        return "ClassMetadataInterceptorFactory [class=" + this.classMetadata.getJavaClass().getName() + "]";
    }
}

