/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class MetaAnnotationStore
implements Service {
    private final LoadingCache<Class<Annotation>, StereotypeModel<Annotation>> stereotypes;
    private final LoadingCache<Class<Annotation>, ScopeModel<Annotation>> scopes;
    private final LoadingCache<Class<Annotation>, QualifierModel<Annotation>> qualifiers;
    private final LoadingCache<Class<Annotation>, InterceptorBindingModel<Annotation>> interceptorBindings;

    public MetaAnnotationStore(ClassTransformer classTransformer) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.stereotypes = cacheBuilder.build((CacheLoader)new StereotypeFunction(classTransformer));
        this.scopes = cacheBuilder.build((CacheLoader)new ScopeFunction(classTransformer));
        this.qualifiers = cacheBuilder.build((CacheLoader)new QualifierFunction(classTransformer));
        this.interceptorBindings = cacheBuilder.build((CacheLoader)new InterceptorBindingFunction(classTransformer));
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.stereotypes.invalidate(annotationClass);
        this.scopes.invalidate(annotationClass);
        this.qualifiers.invalidate(annotationClass);
        this.interceptorBindings.invalidate(annotationClass);
    }

    public <T extends Annotation> StereotypeModel<T> getStereotype(Class<T> stereotype) {
        return (StereotypeModel)LoadingCacheUtils.getCastCacheValue(this.stereotypes, stereotype);
    }

    public <T extends Annotation> ScopeModel<T> getScopeModel(Class<T> scope) {
        return (ScopeModel)LoadingCacheUtils.getCastCacheValue(this.scopes, scope);
    }

    public <T extends Annotation> QualifierModel<T> getBindingTypeModel(Class<T> bindingType) {
        return (QualifierModel)LoadingCacheUtils.getCastCacheValue(this.qualifiers, bindingType);
    }

    public String toString() {
        String newLine = "\n";
        StringBuilder buffer = new StringBuilder();
        buffer.append("Metadata cache").append("\n");
        buffer.append("Registered binding type models: ").append(this.qualifiers.size()).append("\n");
        buffer.append("Registered scope type models: ").append(this.scopes.size()).append("\n");
        buffer.append("Registered stereotype models: ").append(this.stereotypes.size()).append("\n");
        buffer.append("Registered interceptor binding models: ").append(this.interceptorBindings.size()).append("\n");
        return buffer.toString();
    }

    @Override
    public void cleanup() {
        this.qualifiers.invalidateAll();
        this.scopes.invalidateAll();
        this.stereotypes.invalidateAll();
        this.interceptorBindings.invalidateAll();
    }

    public <T extends Annotation> InterceptorBindingModel<T> getInterceptorBindingModel(Class<T> interceptorBinding) {
        return (InterceptorBindingModel)LoadingCacheUtils.getCastCacheValue(this.interceptorBindings, interceptorBinding);
    }

    private static class InterceptorBindingFunction
    extends AbstractMetaAnnotationFunction<InterceptorBindingModel<Annotation>> {
        public InterceptorBindingFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public InterceptorBindingModel<Annotation> load(Class<Annotation> from) {
            return new InterceptorBindingModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class QualifierFunction
    extends AbstractMetaAnnotationFunction<QualifierModel<Annotation>> {
        public QualifierFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public QualifierModel<Annotation> load(Class<Annotation> from) {
            return new QualifierModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class ScopeFunction
    extends AbstractMetaAnnotationFunction<ScopeModel<Annotation>> {
        public ScopeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public ScopeModel<Annotation> load(Class<Annotation> from) {
            return new ScopeModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static class StereotypeFunction
    extends AbstractMetaAnnotationFunction<StereotypeModel<Annotation>> {
        public StereotypeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        public StereotypeModel<Annotation> load(Class<Annotation> from) {
            return new StereotypeModel<Annotation>(this.getClassTransformer().getEnhancedAnnotation(from));
        }
    }

    private static abstract class AbstractMetaAnnotationFunction<M extends AnnotationModel<Annotation>>
    extends CacheLoader<Class<Annotation>, M> {
        private final ClassTransformer classTransformer;

        private AbstractMetaAnnotationFunction(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        public ClassTransformer getClassTransformer() {
            return this.classTransformer;
        }
    }
}

