/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Named;
import javax.inject.Provider;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.literal.NamedLiteral;
import org.jboss.weld.literal.NewLiteral;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.logging.ResolutionLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.BeanTypeAssignabilityRules;
import org.jboss.weld.resolution.DelegateInjectionPointAssignabilityRules;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.reflection.Reflections;

public class ResolvableBuilder {
    private static final Class<?>[] FACADE_TYPES = new Class[]{Event.class, Instance.class, Provider.class};
    private static final Class<?>[] METADATA_TYPES = new Class[]{Interceptor.class, Decorator.class, Bean.class};
    private static final Set<QualifierInstance> ANY_SINGLETON = Collections.singleton(QualifierInstance.ANY);
    protected Class<?> rawType;
    protected final Set<Type> types;
    protected final Set<Annotation> qualifiers;
    protected final Set<QualifierInstance> qualifierInstances;
    protected final Map<Class<? extends Annotation>, Annotation> mappedQualifiers;
    protected Bean<?> declaringBean;
    private final MetaAnnotationStore store;
    protected boolean delegate;

    public ResolvableBuilder(MetaAnnotationStore store) {
        this.store = store;
        this.types = new HashSet<Type>();
        this.qualifiers = new HashSet<Annotation>();
        this.mappedQualifiers = new HashMap<Class<? extends Annotation>, Annotation>();
        this.qualifierInstances = new HashSet<QualifierInstance>();
    }

    public ResolvableBuilder(BeanManagerImpl manager) {
        this(manager.getServices().get(MetaAnnotationStore.class));
    }

    public ResolvableBuilder(Type type, BeanManagerImpl beanManager) {
        this(beanManager);
        if (type != null) {
            this.rawType = Reflections.getRawType(type);
            if (this.rawType == null || type instanceof TypeVariable) {
                throw ResolutionLogger.LOG.cannotExtractRawType(type);
            }
            this.types.add(type);
        }
    }

    public ResolvableBuilder(InjectionPoint injectionPoint, BeanManagerImpl manager) {
        this(injectionPoint.getType(), manager);
        this.addQualifiers(injectionPoint.getQualifiers());
        if (this.mappedQualifiers.containsKey(Named.class) && injectionPoint.getMember() instanceof Field) {
            Named named = (Named)this.mappedQualifiers.get(Named.class);
            QualifierInstance qualifierInstance = new QualifierInstance((Annotation)named, this.store);
            if (named.value().equals("")) {
                this.qualifiers.remove(named);
                this.qualifierInstances.remove(qualifierInstance);
                named = new NamedLiteral(injectionPoint.getMember().getName());
                qualifierInstance = new QualifierInstance((Annotation)named, this.store);
                this.qualifiers.add((Annotation)named);
                this.qualifierInstances.add(qualifierInstance);
                this.mappedQualifiers.put(Named.class, (Annotation)named);
            }
        }
        this.setDeclaringBean(injectionPoint.getBean());
        this.delegate = injectionPoint.isDelegate();
    }

    public ResolvableBuilder setDeclaringBean(Bean<?> declaringBean) {
        this.declaringBean = declaringBean;
        return this;
    }

    public ResolvableBuilder addType(Type type) {
        this.types.add(type);
        return this;
    }

    public ResolvableBuilder addTypes(Set<Type> types) {
        this.types.addAll(types);
        return this;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public Resolvable create() {
        if (this.qualifiers.size() == 0) {
            this.qualifierInstances.add(new QualifierInstance((Annotation)DefaultLiteral.INSTANCE, this.store));
        }
        for (Type type : this.types) {
            Class rawType = Reflections.getRawType(type);
            for (Class<?> facadeType : FACADE_TYPES) {
                if (!facadeType.equals(rawType)) continue;
                return this.createFacade(facadeType);
            }
            for (Class<?> metadataType : METADATA_TYPES) {
                if (!metadataType.equals(rawType)) continue;
                return this.createMetadataProvider(metadataType);
            }
        }
        return new ResolvableImpl(this.rawType, this.types, this.mappedQualifiers, this.declaringBean, this.qualifierInstances, this.delegate);
    }

    private Resolvable createFacade(Class<?> rawType) {
        Set<Type> types = Collections.singleton(rawType);
        return new ResolvableImpl(rawType, types, this.mappedQualifiers, this.declaringBean, ANY_SINGLETON, this.delegate);
    }

    private Resolvable createMetadataProvider(Class<?> rawType) {
        Set<Type> types = Collections.singleton(rawType);
        return new ResolvableImpl(rawType, types, this.mappedQualifiers, this.declaringBean, this.qualifierInstances, this.delegate);
    }

    public ResolvableBuilder addQualifier(Annotation qualifier) {
        QualifierInstance qualifierInstance = new QualifierInstance((Annotation)qualifier, this.store);
        Class<? extends Annotation> annotationType = qualifierInstance.getAnnotationClass();
        if (annotationType.equals(New.class)) {
            New newQualifier = (New)New.class.cast(qualifier);
            if (newQualifier.value().equals(New.class) && this.rawType == null) {
                throw new IllegalStateException("Cannot transform @New when there is no known raw type");
            }
            if (newQualifier.value().equals(New.class)) {
                qualifier = new NewLiteral(this.rawType);
                qualifierInstance = new QualifierInstance((Annotation)qualifier, this.store);
            }
        }
        this.checkQualifier((Annotation)qualifier, qualifierInstance, annotationType);
        this.qualifiers.add((Annotation)qualifier);
        this.qualifierInstances.add(qualifierInstance);
        this.mappedQualifiers.put(annotationType, (Annotation)qualifier);
        return this;
    }

    public ResolvableBuilder addQualifierIfAbsent(Annotation qualifier) {
        if (!this.qualifiers.contains(qualifier)) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public ResolvableBuilder addQualifiers(Annotation[] qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    public ResolvableBuilder addQualifiers(Collection<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.addQualifier(qualifier);
        }
        return this;
    }

    protected void checkQualifier(Annotation qualifier, QualifierInstance qualifierInstance, Class<? extends Annotation> annotationType) {
        if (!this.store.getBindingTypeModel(annotationType).isValid()) {
            throw BeanManagerLogger.LOG.invalidQualifier(qualifier);
        }
        if (this.qualifierInstances.contains(qualifierInstance)) {
            throw BeanManagerLogger.LOG.duplicateQualifiers(this.qualifiers);
        }
    }

    protected MetaAnnotationStore getMetaAnnotationStore() {
        return this.store;
    }

    protected static class ResolvableImpl
    implements Resolvable {
        private final Set<QualifierInstance> qualifierInstances;
        private final Map<Class<? extends Annotation>, Annotation> mappedQualifiers;
        private final Set<Type> typeClosure;
        private final Class<?> rawType;
        private final Bean<?> declaringBean;
        private final boolean delegate;

        protected ResolvableImpl(Class<?> rawType, Set<Type> typeClosure, Map<Class<? extends Annotation>, Annotation> mappedQualifiers, Bean<?> declaringBean, Set<QualifierInstance> qualifierInstances, boolean delegate) {
            this.mappedQualifiers = mappedQualifiers;
            this.typeClosure = typeClosure;
            this.rawType = rawType;
            this.declaringBean = declaringBean;
            this.qualifierInstances = qualifierInstances;
            this.delegate = delegate;
        }

        @Override
        public Set<QualifierInstance> getQualifiers() {
            return this.qualifierInstances;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.mappedQualifiers.containsKey(annotationType);
        }

        @Override
        public Set<Type> getTypes() {
            return this.typeClosure;
        }

        @Override
        public boolean isAssignableTo(Class<?> clazz) {
            BeanTypeAssignabilityRules rules = null;
            rules = this.isDelegate() ? DelegateInjectionPointAssignabilityRules.instance() : BeanTypeAssignabilityRules.instance();
            return rules.isAssignableFrom(clazz, this.typeClosure);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return (A)((Annotation)Reflections.cast(this.mappedQualifiers.get(annotationType)));
        }

        @Override
        public Class<?> getJavaClass() {
            return this.rawType;
        }

        @Override
        public Bean<?> getDeclaringBean() {
            return this.declaringBean;
        }

        public String toString() {
            return "Types: " + this.getTypes() + "; Bindings: " + this.getQualifiers();
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.getTypes().hashCode();
            result = 31 * result + this.qualifierInstances.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (o instanceof ResolvableImpl) {
                ResolvableImpl r = (ResolvableImpl)o;
                return this.getTypes().equals(r.getTypes()) && this.qualifierInstances.equals(r.qualifierInstances);
            }
            return false;
        }

        @Override
        public boolean isDelegate() {
            return this.delegate;
        }
    }
}

