/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractBeanDiscoveryEvent;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.reflection.Reflections;

public class AfterBeanDiscoveryImpl
extends AbstractBeanDiscoveryEvent
implements AfterBeanDiscovery {
    private static final String TYPE_ARGUMENT_NAME = "type";
    private final SlimAnnotatedTypeStore slimAnnotatedTypeStore;

    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        new AfterBeanDiscoveryImpl(beanManager, deployment, bdaMapping, contexts).fire();
    }

    protected AfterBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)AfterBeanDiscovery.class), bdaMapping, deployment, contexts);
        this.slimAnnotatedTypeStore = beanManager.getServices().get(SlimAnnotatedTypeStore.class);
    }

    public void addDefinitionError(Throwable t) {
        this.checkWithinObserverNotification();
        this.getErrors().add(t);
    }

    public List<Throwable> getDefinitionErrors() {
        return Collections.unmodifiableList(this.getErrors());
    }

    public void addBean(Bean<?> bean) {
        this.checkWithinObserverNotification();
        this.processBean(bean);
    }

    protected <T> void processBean(Bean<T> b) {
        PassivationCapable passivationCapable;
        Bean<T> bean = b;
        BeanManagerImpl beanManager = this.getOrCreateBeanDeployment(bean.getBeanClass()).getBeanManager();
        ExternalBeanAttributesFactory.validateBeanAttributes(bean, beanManager);
        ContainerLifecycleEvents containerLifecycleEvents = beanManager.getServices().get(ContainerLifecycleEvents.class);
        if (bean instanceof PassivationCapable && (passivationCapable = (PassivationCapable)bean).getId() == null) {
            throw BeanLogger.LOG.passivationCapableBeanHasNullId(bean);
        }
        if (bean instanceof Interceptor) {
            beanManager.addInterceptor((Interceptor)bean);
        } else if (bean instanceof Decorator) {
            beanManager.addDecorator(CustomDecoratorWrapper.of((Decorator)bean, beanManager));
        } else {
            beanManager.addBean(bean);
        }
        containerLifecycleEvents.fireProcessBean(beanManager, bean);
    }

    public void addContext(Context context) {
        this.checkWithinObserverNotification();
        this.getBeanManager().addContext(context);
    }

    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        this.checkWithinObserverNotification();
        BeanManagerImpl manager = this.getOrCreateBeanDeployment(observerMethod.getBeanClass()).getBeanManager();
        if (Observers.isObserverMethodEnabled(observerMethod, manager)) {
            ProcessObserverMethodImpl.fire(manager, observerMethod);
            manager.addObserver(observerMethod);
        }
        this.getOrCreateBeanDeployment(observerMethod.getBeanClass()).getBeanManager().addObserver(observerMethod);
    }

    public <T> AnnotatedType<T> getAnnotatedType(Class<T> type, String id) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(type, TYPE_ARGUMENT_NAME);
        return this.slimAnnotatedTypeStore.get(type, id);
    }

    public <T> Iterable<AnnotatedType<T>> getAnnotatedTypes(Class<T> type) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(type, TYPE_ARGUMENT_NAME);
        return (Iterable)Reflections.cast(this.slimAnnotatedTypeStore.get(type));
    }
}

