/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.bootstrap.events.RequiredAnnotationDiscovery;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

public class ProcessAnnotatedTypeEventResolvable
implements Resolvable {
    private static final Set<QualifierInstance> QUALIFIERS = Collections.singleton(QualifierInstance.ANY);
    private final Set<Type> types;
    private final SlimAnnotatedType<?> annotatedType;
    private final RequiredAnnotationDiscovery discovery;

    public static ProcessAnnotatedTypeEventResolvable of(ProcessAnnotatedTypeImpl<?> event, RequiredAnnotationDiscovery discovery) {
        if (event instanceof ProcessSyntheticAnnotatedType) {
            return ProcessAnnotatedTypeEventResolvable.forProcessSyntheticAnnotatedType(event.getOriginalAnnotatedType(), discovery);
        }
        return ProcessAnnotatedTypeEventResolvable.forProcessAnnotatedType(event.getOriginalAnnotatedType(), discovery);
    }

    public static ProcessAnnotatedTypeEventResolvable forProcessAnnotatedType(SlimAnnotatedType<?> annotatedType, RequiredAnnotationDiscovery discovery) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl((Type)((Object)ProcessAnnotatedType.class), new Type[]{annotatedType.getJavaClass()}, null);
        return new ProcessAnnotatedTypeEventResolvable(Sets.newHashSet((Object[])new Type[]{Object.class, type}), annotatedType, discovery);
    }

    public static ProcessAnnotatedTypeEventResolvable forProcessSyntheticAnnotatedType(SlimAnnotatedType<?> annotatedType, RequiredAnnotationDiscovery discovery) {
        ParameterizedTypeImpl type1 = new ParameterizedTypeImpl((Type)((Object)ProcessAnnotatedType.class), new Type[]{annotatedType.getJavaClass()}, null);
        ParameterizedTypeImpl type2 = new ParameterizedTypeImpl((Type)((Object)ProcessSyntheticAnnotatedType.class), new Type[]{annotatedType.getJavaClass()}, null);
        return new ProcessAnnotatedTypeEventResolvable(Sets.newHashSet((Object[])new Type[]{Object.class, type1, type2}), annotatedType, discovery);
    }

    protected ProcessAnnotatedTypeEventResolvable(Set<Type> types, SlimAnnotatedType<?> annotatedType, RequiredAnnotationDiscovery discovery) {
        this.types = types;
        this.annotatedType = annotatedType;
        this.discovery = discovery;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public Set<QualifierInstance> getQualifiers() {
        return QUALIFIERS;
    }

    public boolean containsRequiredAnnotations(Collection<Class<? extends Annotation>> requiredAnnotations) {
        if (this.annotatedType instanceof BackedAnnotatedType) {
            return this.containsAnnotation((BackedAnnotatedType)this.annotatedType, requiredAnnotations);
        }
        if (this.annotatedType instanceof UnbackedAnnotatedType) {
            return this.containsAnnotation((UnbackedAnnotatedType)this.annotatedType, requiredAnnotations);
        }
        throw new IllegalArgumentException("Unknown SlimAnnotatedType implementation: " + this.annotatedType.getClass().toString());
    }

    protected boolean containsAnnotation(UnbackedAnnotatedType<?> annotatedType, Collection<Class<? extends Annotation>> requiredAnnotations) {
        for (Class<? extends Annotation> requiredAnnotation : requiredAnnotations) {
            if (!this.apply(annotatedType, requiredAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualOrAnnotated(Class<? extends Annotation> requiredAnnotation, Annotation annotation) {
        return annotation.annotationType().equals(requiredAnnotation) || annotation.annotationType().isAnnotationPresent(requiredAnnotation);
    }

    protected boolean apply(UnbackedAnnotatedType<?> annotatedType, Class<? extends Annotation> requiredAnnotation) {
        for (Annotation annotation : annotatedType.getAnnotations()) {
            if (ProcessAnnotatedTypeEventResolvable.isEqualOrAnnotated(requiredAnnotation, annotation)) {
                return true;
            }
            if (!ProcessAnnotatedTypeEventResolvable.isEqualOrAnnotated(requiredAnnotation, annotation)) continue;
            return true;
        }
        for (AnnotatedField annotatedField : annotatedType.getFields()) {
            for (Annotation annotation : annotatedField.getAnnotations()) {
                if (!ProcessAnnotatedTypeEventResolvable.isEqualOrAnnotated(requiredAnnotation, annotation)) continue;
                return true;
            }
        }
        for (AnnotatedConstructor annotatedConstructor : annotatedType.getConstructors()) {
            for (Annotation annotation : annotatedConstructor.getAnnotations()) {
                if (!ProcessAnnotatedTypeEventResolvable.isEqualOrAnnotated(requiredAnnotation, annotation)) continue;
                return true;
            }
            for (AnnotatedParameter parameter : annotatedConstructor.getParameters()) {
                for (Annotation annotation : parameter.getAnnotations()) {
                    if (!ProcessAnnotatedTypeEventResolvable.isEqualOrAnnotated(requiredAnnotation, annotation)) continue;
                    return true;
                }
            }
        }
        for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
            for (Annotation annotation : annotatedMethod.getAnnotations()) {
                if (!ProcessAnnotatedTypeEventResolvable.isEqualOrAnnotated(requiredAnnotation, annotation)) continue;
                return true;
            }
            for (AnnotatedParameter parameter : annotatedMethod.getParameters()) {
                for (Annotation annotation : parameter.getAnnotations()) {
                    if (!ProcessAnnotatedTypeEventResolvable.isEqualOrAnnotated(requiredAnnotation, annotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean containsAnnotation(BackedAnnotatedType<?> annotatedType, Collection<Class<? extends Annotation>> requiredAnnotations) {
        for (Class<? extends Annotation> requiredAnnotation : requiredAnnotations) {
            if (!this.discovery.containsAnnotation(annotatedType.getJavaClass(), requiredAnnotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return false;
    }

    @Override
    public Class<?> getJavaClass() {
        return null;
    }

    @Override
    public Bean<?> getDeclaringBean() {
        return null;
    }

    @Override
    public boolean isDelegate() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessAnnotatedTypeEventResolvable)) {
            return false;
        }
        ProcessAnnotatedTypeEventResolvable other = (ProcessAnnotatedTypeEventResolvable)obj;
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }
}

