/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bootstrap.events.ContainerEvent;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class ProcessAnnotatedTypeImpl<X>
implements ProcessAnnotatedType<X>,
ContainerEvent {
    private final SlimAnnotatedType<X> originalAnnotatedType;
    private final BeanManagerImpl manager;
    private AnnotatedType<X> annotatedType;
    private boolean veto;

    public ProcessAnnotatedTypeImpl(BeanManagerImpl beanManager, SlimAnnotatedType<X> annotatedType) {
        this(beanManager, annotatedType, ProcessAnnotatedType.class);
    }

    protected ProcessAnnotatedTypeImpl(BeanManagerImpl beanManager, SlimAnnotatedType<X> annotatedType, Class<? extends ProcessAnnotatedType> rawType) {
        this.manager = beanManager;
        this.annotatedType = annotatedType;
        this.originalAnnotatedType = annotatedType;
    }

    public AnnotatedType<X> getAnnotatedType() {
        return this.annotatedType;
    }

    public SlimAnnotatedType<X> getResultingAnnotatedType() {
        if (this.isDirty()) {
            return ClassTransformer.instance(this.manager).getUnbackedAnnotatedType(this.originalAnnotatedType, this.annotatedType);
        }
        return this.originalAnnotatedType;
    }

    public SlimAnnotatedType<X> getOriginalAnnotatedType() {
        return this.originalAnnotatedType;
    }

    public void setAnnotatedType(AnnotatedType<X> type) {
        if (type == null) {
            throw BootstrapLogger.LOG.annotationTypeNull(this);
        }
        if (!this.originalAnnotatedType.getJavaClass().equals(type.getJavaClass())) {
            throw BootstrapLogger.LOG.annotatedTypeJavaClassMismatch(this.annotatedType.getJavaClass(), type.getJavaClass());
        }
        AnnotatedTypeValidator.validateAnnotatedType(type);
        this.annotatedType = type;
    }

    public void veto() {
        this.veto = true;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public boolean isDirty() {
        return this.originalAnnotatedType != this.annotatedType;
    }

    public String toString() {
        return this.annotatedType.toString();
    }
}

