/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.ConversationScoped;
import org.jboss.weld.Container;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.context.beanstore.BoundBeanStore;
import org.jboss.weld.context.beanstore.ConversationNamingScheme;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.conversation.ConversationIdGenerator;
import org.jboss.weld.context.conversation.ConversationImpl;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractConversationContext<R, S>
extends AbstractBoundContext<R>
implements ConversationContext {
    private static final String CURRENT_CONVERSATION_ATTRIBUTE_NAME = ConversationContext.class.getName() + ".currentConversation";
    public static final String CONVERSATIONS_ATTRIBUTE_NAME = ConversationContext.class.getName() + ".conversations";
    private static final long DEFAULT_TIMEOUT = 600000L;
    private static final long CONCURRENT_ACCESS_TIMEOUT = 1000L;
    private static final String PARAMETER_NAME = "cid";
    private final AtomicReference<String> parameterName = new AtomicReference<String>("cid");
    private final AtomicLong defaultTimeout = new AtomicLong(600000L);
    private final AtomicLong concurrentAccessTimeout = new AtomicLong(1000L);
    private final ThreadLocal<R> associated = new ThreadLocal();
    private final BeanManagerImpl manager;
    private final BeanIdentifierIndex beanIdentifierIndex;

    public AbstractConversationContext(String contextId, BeanIdentifierIndex beanIdentifierIndex) {
        super(contextId, true);
        this.manager = Container.instance(contextId).deploymentManager();
        this.beanIdentifierIndex = beanIdentifierIndex;
    }

    @Override
    public String getParameterName() {
        return this.parameterName.get();
    }

    @Override
    public void setParameterName(String cid) {
        this.parameterName.set(cid);
    }

    @Override
    public void setConcurrentAccessTimeout(long timeout) {
        this.concurrentAccessTimeout.set(timeout);
    }

    @Override
    public long getConcurrentAccessTimeout() {
        return this.concurrentAccessTimeout.get();
    }

    @Override
    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout.set(timeout);
    }

    @Override
    public long getDefaultTimeout() {
        return this.defaultTimeout.get();
    }

    @Override
    public boolean associate(R request) {
        if (this.associated.get() == null) {
            this.associated.set(request);
            if (this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, false) == null) {
                ConversationIdGenerator generator = new ConversationIdGenerator();
                this.setRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, generator);
                this.setSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, generator, false);
            } else {
                this.setRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, true));
            }
            if (this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, false) == null) {
                HashMap conversations = new HashMap();
                this.setRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversations);
                this.setSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, conversations, false);
            } else {
                this.setRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, true));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dissociate(R request) {
        if (this.isAssociated()) {
            try {
                this.copyConversationIdGeneratorAndConversationsToSession();
                this.associated.set(null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cleanup();
            }
        }
        return false;
    }

    public void copyConversationIdGeneratorAndConversationsToSession() {
        if (!this.isAssociated()) {
            return;
        }
        R request = this.associated.get();
        if (this.getSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, false) == null) {
            this.setSessionAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME, this.getRequestAttribute(request, ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME), false);
        }
        if (this.getSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, false) == null) {
            this.setSessionAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME, this.getRequestAttribute(request, CONVERSATIONS_ATTRIBUTE_NAME), false);
        }
    }

    public void sessionCreated() {
        this.copyConversationIdGeneratorAndConversationsToSession();
    }

    protected void associateRequestWithNewConversation() {
        ConversationImpl conversation = new ConversationImpl(this.manager);
        this.lock(conversation);
        this.setRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME, conversation);
        ConversationNamingScheme namingScheme = new ConversationNamingScheme(this.getNamingSchemePrefix(), "transient", this.beanIdentifierIndex);
        this.setBeanStore(this.createRequestBeanStore(namingScheme, this.getRequest()));
        this.setRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME, namingScheme);
    }

    protected void associateRequest(ManagedConversation conversation) {
        this.setRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME, conversation);
        ConversationNamingScheme namingScheme = new ConversationNamingScheme(this.getNamingSchemePrefix(), conversation.getId(), this.beanIdentifierIndex);
        this.setBeanStore(this.createRequestBeanStore(namingScheme, this.getRequest()));
        this.getBeanStore().attach();
    }

    @Override
    public void activate() {
        this.activate(null);
    }

    @Override
    public void activate(String cid) {
        if (!this.isActive()) {
            if (!this.isAssociated()) {
                throw ConversationLogger.LOG.mustCallAssociateBeforeActivate();
            }
        } else {
            throw ConversationLogger.LOG.contextAlreadyActive();
        }
        super.setActive(true);
        this.initialize(cid);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initialize(String cid) {
        if (cid != null && !cid.isEmpty()) {
            ManagedConversation conversation = this.getConversation(cid);
            if (conversation != null && !AbstractConversationContext.isExpired(conversation)) {
                boolean lock = this.lock(conversation);
                if (lock) {
                    this.associateRequest(conversation);
                    return;
                }
                this.associateRequestWithNewConversation();
                throw ConversationLogger.LOG.conversationLockTimedout(cid);
            }
            this.associateRequestWithNewConversation();
            throw ConversationLogger.LOG.noConversationFoundToRestore(cid);
        }
        this.associateRequestWithNewConversation();
    }

    private boolean lock(ManagedConversation conversation) {
        return conversation.lock(this.getConcurrentAccessTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        if (this.isActive()) {
            if (!this.isAssociated()) {
                throw ConversationLogger.LOG.mustCallAssociateBeforeDeactivate();
            }
            if (this.getCurrentConversation().isTransient()) {
                this.destroy();
            } else {
                try {
                    this.getCurrentConversation().touch();
                    if (!this.getBeanStore().isAttached()) {
                        if (!(this.getRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME) instanceof ConversationNamingScheme)) {
                            throw ConversationLogger.LOG.conversationNamingSchemeNotFound();
                        }
                        ((ConversationNamingScheme)this.getRequestAttribute(this.getRequest(), ConversationNamingScheme.PARAMETER_NAME)).setCid(this.getCurrentConversation().getId());
                        this.getBeanStore().attach();
                        this.getConversationMap().put(this.getCurrentConversation().getId(), this.getCurrentConversation());
                    }
                }
                finally {
                    this.getCurrentConversation().unlock();
                }
            }
            this.setBeanStore(null);
            Iterator<Map.Entry<String, ManagedConversation>> entryIterator = this.getConversationMap().entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<String, ManagedConversation> entry = entryIterator.next();
                if (!entry.getValue().isTransient()) continue;
                this.destroyConversation(this.getSessionFromRequest(this.getRequest(), false), entry.getKey());
                entryIterator.remove();
            }
        } else {
            throw ConversationLogger.LOG.contextNotActive();
        }
        super.setActive(false);
    }

    public void conversationPromotedToLongRunning(ConversationImpl conversation) {
        this.getConversationMap().put(conversation.getId(), conversation);
    }

    @Override
    public void invalidate() {
        for (ManagedConversation conversation : this.getConversations()) {
            if (conversation == this.getCurrentConversation() || conversation.isTransient() || !AbstractConversationContext.isExpired(conversation)) continue;
            conversation.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy(S session) {
        BoundBeanStore beanStore = this.getBeanStore();
        boolean active = this.isActive();
        if (beanStore != null) {
            beanStore.detach();
        }
        try {
            if (this.getSessionAttributeFromSession(session, CONVERSATIONS_ATTRIBUTE_NAME) instanceof Map) {
                Map conversations = (Map)Reflections.cast(this.getSessionAttributeFromSession(session, CONVERSATIONS_ATTRIBUTE_NAME));
                this.setActive(true);
                for (ManagedConversation conversation : conversations.values()) {
                    String id = conversation.getId();
                    if (!conversation.isTransient()) {
                        conversation.end();
                    }
                    if (this.isCurrentConversation(id)) continue;
                    this.destroyConversation(session, id);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.setBeanStore(beanStore);
            this.setActive(active);
            if (beanStore != null) {
                this.getBeanStore().attach();
            } else if (!this.isActive()) {
                this.cleanup();
            }
        }
    }

    private boolean isCurrentConversation(String id) {
        if (!this.isAssociated()) {
            return false;
        }
        return id != null && id.equals(this.getCurrentConversation().getId());
    }

    protected void destroyConversation(S session, String id) {
        if (session != null) {
            this.setBeanStore(this.createSessionBeanStore(new ConversationNamingScheme(this.getNamingSchemePrefix(), id, this.beanIdentifierIndex), session));
            this.getBeanStore().attach();
            this.destroy();
            this.getBeanStore().detach();
            this.setBeanStore(null);
            this.manager.getGlobalLenientObserverNotifier().fireEvent((Object)id, new Annotation[]{DestroyedLiteral.CONVERSATION});
        }
    }

    @Override
    public String generateConversationId() {
        if (!this.isAssociated()) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeGeneratingId();
        }
        if (!(this.getRequestAttribute(this.getRequest(), ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME) instanceof ConversationIdGenerator)) {
            throw ConversationLogger.LOG.conversationIdGeneratorNotFound();
        }
        this.checkContextInitialized();
        ConversationIdGenerator generator = (ConversationIdGenerator)this.getRequestAttribute(this.getRequest(), ConversationIdGenerator.CONVERSATION_ID_GENERATOR_ATTRIBUTE_NAME);
        return generator.call();
    }

    private static boolean isExpired(ManagedConversation conversation) {
        return System.currentTimeMillis() > conversation.getLastUsed() + conversation.getTimeout();
    }

    @Override
    public ManagedConversation getConversation(String id) {
        return this.getConversationMap().get(id);
    }

    @Override
    public Collection<ManagedConversation> getConversations() {
        return this.getConversationMap().values();
    }

    private void checkIsAssociated() {
        if (!this.isAssociated()) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeLoadingKnownConversations();
        }
    }

    private Map<String, ManagedConversation> getConversationMap() {
        this.checkIsAssociated();
        this.checkContextInitialized();
        if (!(this.getRequestAttribute(this.getRequest(), CONVERSATIONS_ATTRIBUTE_NAME) instanceof Map)) {
            throw ConversationLogger.LOG.unableToLoadCurrentConversations();
        }
        return (Map)Reflections.cast(this.getRequestAttribute(this.getRequest(), CONVERSATIONS_ATTRIBUTE_NAME));
    }

    @Override
    public ManagedConversation getCurrentConversation() {
        this.checkIsAssociated();
        this.checkContextInitialized();
        if (!(this.getRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME) instanceof ManagedConversation)) {
            throw ConversationLogger.LOG.unableToLoadCurrentConversations();
        }
        return (ManagedConversation)this.getRequestAttribute(this.getRequest(), CURRENT_CONVERSATION_ATTRIBUTE_NAME);
    }

    public Class<? extends Annotation> getScope() {
        return ConversationScoped.class;
    }

    protected abstract void setSessionAttribute(R var1, String var2, Object var3, boolean var4);

    protected abstract Object getSessionAttribute(R var1, String var2, boolean var3);

    protected abstract Object getSessionAttributeFromSession(S var1, String var2);

    protected abstract void removeRequestAttribute(R var1, String var2);

    protected abstract void setRequestAttribute(R var1, String var2, Object var3);

    protected abstract Object getRequestAttribute(R var1, String var2);

    protected abstract BoundBeanStore createRequestBeanStore(NamingScheme var1, R var2);

    protected abstract BoundBeanStore createSessionBeanStore(NamingScheme var1, S var2);

    protected abstract S getSessionFromRequest(R var1, boolean var2);

    protected abstract String getNamingSchemePrefix();

    protected boolean isAssociated() {
        return this.associated.get() != null;
    }

    protected R getRequest() {
        return this.associated.get();
    }
}

