/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.security.SetAccessibleAction;

public class QualifierInstance {
    public static final QualifierInstance ANY = new QualifierInstance(Any.class);
    private final Class<? extends Annotation> annotationClass;
    private final Map<AnnotatedMethod<?>, Object> values;
    private final int hashCode;

    public static QualifierInstance of(Annotation annotation, MetaAnnotationStore store) {
        return new QualifierInstance(annotation.annotationType(), QualifierInstance.createValues(annotation, store));
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass) {
        this(annotationClass, Collections.emptyMap());
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass, Map<AnnotatedMethod<?>, Object> values) {
        this.annotationClass = annotationClass;
        this.values = values;
        this.hashCode = Objects.hashCode((Object[])new Object[]{annotationClass, values});
    }

    private static Map<AnnotatedMethod<?>, Object> createValues(Annotation instance, MetaAnnotationStore store) {
        Class<? extends Annotation> annotationClass = instance.annotationType();
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(annotationClass);
        if (model.getAnnotatedAnnotation().getMethods().size() == 0) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AnnotatedMethod method : model.getAnnotatedAnnotation().getMethods()) {
            if (model.getNonBindingMembers().contains(method)) continue;
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(SetAccessibleAction.of(method.getJavaMember()));
                } else {
                    method.getJavaMember().setAccessible(true);
                }
                builder.put((Object)method, method.getJavaMember().invoke((Object)instance, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new WeldException(e);
            }
            catch (InvocationTargetException e) {
                throw new WeldException(e);
            }
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifierInstance that = (QualifierInstance)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "QualifierInstance{annotationClass=" + this.annotationClass + ", values=" + this.values + ", hashCode=" + this.hashCode + '}';
    }
}

