/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Member;
import java.util.Collection;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedCallable;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMember;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedMember;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedMemberIdentifier;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;

public class MemberTransformer
implements BootstrapService {
    private final ClassTransformer transformer;
    private final LoadingCache<UnbackedMemberIdentifier<?>, UnbackedAnnotatedMember<?>> unbackedAnnotatedMembersById;
    private final LoadingCache<MemberKey<?, ?>, EnhancedAnnotatedMember<?, ?, ?>> enhancedMemberCache;
    private final EnhancedFieldLoader enhancedFieldLoader;
    private final EnhancedMethodLoader enhancedMethodLoader;
    private final EnhancedConstructorLoader enhancedConstructorLoader;

    public MemberTransformer(ClassTransformer transformer) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.transformer = transformer;
        this.unbackedAnnotatedMembersById = cacheBuilder.build((CacheLoader)new UnbackedMemberById());
        this.enhancedFieldLoader = new EnhancedFieldLoader();
        this.enhancedMethodLoader = new EnhancedMethodLoader();
        this.enhancedConstructorLoader = new EnhancedConstructorLoader();
        this.enhancedMemberCache = cacheBuilder.build((CacheLoader)new EnhancedMemberLoaderFunction());
    }

    public <X> UnbackedAnnotatedMember<X> getUnbackedMember(UnbackedMemberIdentifier<X> identifier) {
        return (UnbackedAnnotatedMember)LoadingCacheUtils.getCastCacheValue(this.unbackedAnnotatedMembersById, identifier);
    }

    public <X, A extends EnhancedAnnotatedMember<?, X, ? extends Member>> A loadEnhancedMember(AnnotatedMember<X> member, String bdaId) {
        if (member instanceof EnhancedAnnotatedMember) {
            return (A)((EnhancedAnnotatedMember)Reflections.cast(member));
        }
        EnhancedAnnotatedType declaringType = this.transformer.getEnhancedAnnotatedType(member.getDeclaringType(), bdaId);
        return (A)((EnhancedAnnotatedMember)LoadingCacheUtils.getCastCacheValue(this.enhancedMemberCache, new MemberKey(declaringType, member)));
    }

    public <X> EnhancedAnnotatedParameter<?, X> loadEnhancedParameter(AnnotatedParameter<X> parameter, String bdaId) {
        if (parameter instanceof EnhancedAnnotatedParameter) {
            return (EnhancedAnnotatedParameter)Reflections.cast(parameter);
        }
        EnhancedAnnotatedCallable callable = (EnhancedAnnotatedCallable)this.loadEnhancedMember((AnnotatedMember<X>)parameter.getDeclaringCallable(), bdaId);
        return callable.getEnhancedParameters().get(parameter.getPosition());
    }

    @Override
    public void cleanupAfterBoot() {
        this.enhancedMemberCache.invalidateAll();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.unbackedAnnotatedMembersById.invalidateAll();
    }

    private class EnhancedConstructorLoader
    extends AbstractEnhancedMemberLoader<AnnotatedConstructor<?>, EnhancedAnnotatedConstructor<?>> {
        private EnhancedConstructorLoader() {
        }

        @Override
        public boolean equals(EnhancedAnnotatedConstructor<?> member1, AnnotatedConstructor<?> member2) {
            return AnnotatedTypes.compareAnnotatedCallable(member1, member2);
        }

        @Override
        public Collection<EnhancedAnnotatedConstructor<?>> getMembersOfDeclaringType(MemberKey<?, AnnotatedConstructor<?>> source) {
            return (Collection)Reflections.cast(((MemberKey)source).type.getConstructors());
        }
    }

    private class EnhancedMethodLoader
    extends AbstractEnhancedMemberLoader<AnnotatedMethod<?>, EnhancedAnnotatedMethod<?, ?>> {
        private EnhancedMethodLoader() {
        }

        @Override
        public boolean equals(EnhancedAnnotatedMethod<?, ?> member1, AnnotatedMethod<?> member2) {
            return AnnotatedTypes.compareAnnotatedCallable(member1, member2);
        }

        @Override
        public Collection<EnhancedAnnotatedMethod<?, ?>> getMembersOfDeclaringType(MemberKey<?, AnnotatedMethod<?>> source) {
            return (Collection)Reflections.cast(((MemberKey)source).type.getMethods());
        }
    }

    private class EnhancedFieldLoader
    extends AbstractEnhancedMemberLoader<AnnotatedField<?>, EnhancedAnnotatedField<?, ?>> {
        private EnhancedFieldLoader() {
        }

        @Override
        public boolean equals(EnhancedAnnotatedField<?, ?> member1, AnnotatedField<?> member2) {
            return AnnotatedTypes.compareAnnotatedField(member1, member2);
        }

        @Override
        public Collection<EnhancedAnnotatedField<?, ?>> getMembersOfDeclaringType(MemberKey<?, AnnotatedField<?>> source) {
            return (Collection)Reflections.cast(((MemberKey)source).type.getFields());
        }
    }

    private abstract class AbstractEnhancedMemberLoader<A extends AnnotatedMember<?>, W extends EnhancedAnnotatedMember<?, ?, ?>> {
        private AbstractEnhancedMemberLoader() {
        }

        public W load(MemberKey<?, A> source) {
            return this.findMatching(this.getMembersOfDeclaringType(source), ((MemberKey)source).member);
        }

        public W findMatching(Collection<W> members, A source) {
            for (EnhancedAnnotatedMember member : members) {
                if (!this.equals(member, source)) continue;
                return (W)member;
            }
            throw BeanLogger.LOG.unableToLoadMember(source);
        }

        public abstract boolean equals(W var1, A var2);

        public abstract Collection<W> getMembersOfDeclaringType(MemberKey<?, A> var1);
    }

    private class EnhancedMemberLoaderFunction
    extends CacheLoader<MemberKey<?, ?>, EnhancedAnnotatedMember<?, ?, ?>> {
        private EnhancedMemberLoaderFunction() {
        }

        public EnhancedAnnotatedMember<?, ?, ?> load(MemberKey<?, ?> from) {
            if (((MemberKey)from).member instanceof AnnotatedField) {
                return MemberTransformer.this.enhancedFieldLoader.load((MemberKey)Reflections.cast(from));
            }
            if (((MemberKey)from).member instanceof AnnotatedMethod) {
                return MemberTransformer.this.enhancedMethodLoader.load((MemberKey)Reflections.cast(from));
            }
            if (((MemberKey)from).member instanceof AnnotatedConstructor) {
                return MemberTransformer.this.enhancedConstructorLoader.load((MemberKey)Reflections.cast(from));
            }
            throw BeanLogger.LOG.invalidAnnotatedMember(from);
        }
    }

    private static class UnbackedMemberById
    extends CacheLoader<UnbackedMemberIdentifier<?>, UnbackedAnnotatedMember<?>> {
        private UnbackedMemberById() {
        }

        public UnbackedAnnotatedMember<?> load(UnbackedMemberIdentifier<?> identifier) {
            return this.findMatchingMember(identifier.getType(), identifier.getMemberId());
        }

        private <T> UnbackedAnnotatedMember<T> findMatchingMember(UnbackedAnnotatedType<T> type, String id) {
            for (AnnotatedField<T> annotatedField : type.getFields()) {
                if (!id.equals(AnnotatedTypes.createFieldId(annotatedField))) continue;
                return (UnbackedAnnotatedMember)Reflections.cast(annotatedField);
            }
            for (AnnotatedMethod annotatedMethod : type.getMethods()) {
                if (!id.equals(AnnotatedTypes.createMethodId(annotatedMethod.getJavaMember(), annotatedMethod.getAnnotations(), annotatedMethod.getParameters()))) continue;
                return (UnbackedAnnotatedMember)Reflections.cast(annotatedMethod);
            }
            for (AnnotatedConstructor annotatedConstructor : type.getConstructors()) {
                if (!id.equals(AnnotatedTypes.createConstructorId(annotatedConstructor.getJavaMember(), annotatedConstructor.getAnnotations(), annotatedConstructor.getParameters()))) continue;
                return (UnbackedAnnotatedMember)Reflections.cast(annotatedConstructor);
            }
            throw BeanLogger.LOG.unableToLoadMember(id);
        }
    }

    private static class MemberKey<X, A extends AnnotatedMember<X>> {
        private final EnhancedAnnotatedType<X> type;
        private final A member;
        private final int hashCode;

        public MemberKey(EnhancedAnnotatedType<X> type, A member) {
            this.type = type;
            this.member = member;
            this.hashCode = Objects.hashCode((Object[])new Object[]{type, member});
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberKey) {
                MemberKey that = (MemberKey)obj;
                return Objects.equal(this.type, that.type) && Objects.equal(this.member, that.member);
            }
            return false;
        }
    }
}

