/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.cache;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.jboss.weld.logging.UtilLogger;

public final class LoadingCacheUtils {
    private LoadingCacheUtils() {
    }

    public static <K, V> V getCacheValue(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException e) {
            throw UtilLogger.LOG.unableToLoadCacheValue(key, e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw UtilLogger.LOG.unableToLoadCacheValue(key, cause);
        }
    }

    public static <T, K, V> T getCastCacheValue(LoadingCache<K, V> cache, Object key) {
        return (T)LoadingCacheUtils.getCacheValue(cache, key);
    }
}

