/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.io.File;
import java.security.AccessController;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetBooleanSystemPropertyAction;
import org.jboss.weld.security.GetSystemPropertyAction;

public final class SystemPropertiesConfiguration {
    public static final String DISABLE_XML_VALIDATION_KEY = "org.jboss.weld.xml.disableValidating";
    public static final String NON_PORTABLE_MODE_KEY = "org.jboss.weld.nonPortableMode";
    public static final String CLIENT_PROXY_DUMP_PATH = "org.jboss.weld.proxy.dump";
    public static final String INJECTABLE_REFERENCE_OPTIMIZATION = "org.jboss.weld.injectableReferenceOptimization";
    public static final SystemPropertiesConfiguration INSTANCE = new SystemPropertiesConfiguration();
    private final boolean xmlValidationDisabled = this.initBooleanSystemProperty("org.jboss.weld.xml.disableValidating", false);
    private final boolean nonPortableModeEnabled = this.initBooleanSystemProperty("org.jboss.weld.nonPortableMode", false);
    private final File proxyDumpPath;
    private final boolean injectableReferenceOptimization = this.initBooleanSystemProperty("org.jboss.weld.injectableReferenceOptimization", false);

    private SystemPropertiesConfiguration() {
        String dumpPathString = AccessController.doPrivileged(new GetSystemPropertyAction(CLIENT_PROXY_DUMP_PATH));
        if (dumpPathString != null && !dumpPathString.isEmpty()) {
            File tmp = new File(dumpPathString);
            if (!tmp.isDirectory() && !tmp.mkdirs()) {
                BeanLogger.LOG.directoryCannotBeCreated(tmp.toString());
                this.proxyDumpPath = null;
            } else {
                this.proxyDumpPath = new File(dumpPathString);
            }
        } else {
            this.proxyDumpPath = null;
        }
    }

    public File getProxyDumpPath() {
        return this.proxyDumpPath;
    }

    public boolean isProxyDumpEnabled() {
        return this.proxyDumpPath != null;
    }

    public boolean isXmlValidationDisabled() {
        return this.xmlValidationDisabled;
    }

    public boolean isNonPortableModeEnabled() {
        return this.nonPortableModeEnabled;
    }

    public boolean isInjectableReferenceOptimizationEnabled() {
        return this.injectableReferenceOptimization;
    }

    private boolean initBooleanSystemProperty(String key, boolean defaultValue) {
        try {
            return AccessController.doPrivileged(new GetBooleanSystemPropertyAction(key));
        }
        catch (Throwable ignore) {
            return defaultValue;
        }
    }
}

