/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.injection.AbstractCallableInjectionPoint;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.SecurityActions;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

class StaticMethodInjectionPoint<T, X>
extends AbstractCallableInjectionPoint<T, X, Method>
implements MethodInjectionPoint<T, X> {
    private final int specialInjectionPointIndex;
    private final AnnotatedMethod<X> annotatedMethod;
    final Method accessibleMethod;

    StaticMethodInjectionPoint(EnhancedAnnotatedMethod<T, X> enhancedMethod, Bean<?> declaringBean, Class<?> declaringComponentClass, Class<? extends Annotation> specialParameterMarker, InjectionPointFactory factory, BeanManagerImpl manager) {
        super(enhancedMethod, declaringBean, declaringComponentClass, specialParameterMarker != null, factory, manager);
        this.accessibleMethod = SecurityActions.getAccessibleCopyOfMethod(enhancedMethod.getJavaMember());
        this.annotatedMethod = enhancedMethod.slim();
        this.specialInjectionPointIndex = StaticMethodInjectionPoint.initSpecialInjectionPointIndex(enhancedMethod, specialParameterMarker);
    }

    private static <X> int initSpecialInjectionPointIndex(EnhancedAnnotatedMethod<?, X> enhancedMethod, Class<? extends Annotation> specialParameterMarker) {
        if (specialParameterMarker == null) {
            return -1;
        }
        List<EnhancedAnnotatedParameter<?, X>> parameters = enhancedMethod.getEnhancedParameters(specialParameterMarker);
        if (parameters.isEmpty()) {
            throw new org.jboss.weld.exceptions.IllegalArgumentException("Not a disposer nor observer method: " + enhancedMethod);
        }
        return parameters.get(0).getPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T invoke(Object receiver, Object specialValue, BeanManagerImpl manager, CreationalContext<?> ctx, Class<? extends RuntimeException> exceptionTypeToThrow) {
        WeldCreationalContext invocationContext = null;
        if (!this.getInjectionPoints().isEmpty()) {
            invocationContext = manager.createCreationalContext((Contextual)null);
        }
        try {
            Object t = Reflections.cast(this.getMethod(receiver).invoke(receiver, this.getParameterValues(specialValue, manager, ctx, invocationContext)));
            return t;
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (SecurityException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        finally {
            if (invocationContext != null) {
                invocationContext.release();
            }
        }
        return null;
    }

    protected Object[] getParameterValues(Object specialVal, BeanManagerImpl manager, CreationalContext<?> ctx, CreationalContext<?> invocationContext) {
        if (this.getInjectionPoints().isEmpty()) {
            if (this.specialInjectionPointIndex == -1) {
                return Arrays2.EMPTY_ARRAY;
            }
            return new Object[]{specialVal};
        }
        Object[] parameterValues = new Object[this.getParameterInjectionPoints().size()];
        Iterator iterator = this.getParameterInjectionPoints().iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint param = iterator.next();
            parameterValues[i] = i == this.specialInjectionPointIndex ? specialVal : (param.getAnnotated().isAnnotationPresent(TransientReference.class) ? param.getValueToInject(manager, invocationContext) : param.getValueToInject(manager, ctx));
        }
        return parameterValues;
    }

    protected Method getMethod(Object receiver) throws NoSuchMethodException {
        return this.accessibleMethod;
    }

    @Override
    public AnnotatedMethod<X> getAnnotated() {
        return this.annotatedMethod;
    }
}

