/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.BeanDeploymentModule;
import org.jboss.weld.bootstrap.BeanDeploymentModules;
import org.jboss.weld.bootstrap.events.BeforeShutdownImpl;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.SingletonContext;
import org.jboss.weld.event.ContextEvent;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldRuntime {
    private BeanManagerImpl deploymentManager;
    private ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap;
    private String contextId;

    public WeldRuntime(String contextId, BeanManagerImpl deploymentManager, ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap) {
        this.contextId = contextId;
        this.deploymentManager = deploymentManager;
        this.bdaToBeanManagerMap = bdaToBeanManagerMap;
    }

    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        BeanManagerImpl beanManager = (BeanManagerImpl)this.bdaToBeanManagerMap.get(beanDeploymentArchive);
        return beanManager == null ? null : beanManager.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        try {
            ((ApplicationContext)this.deploymentManager.instance().select(ApplicationContext.class, new Annotation[0]).get()).invalidate();
            ((SingletonContext)this.deploymentManager.instance().select(SingletonContext.class, new Annotation[0]).get()).invalidate();
        }
        catch (Throwable throwable) {
            try {
                for (BeanDeploymentModule module : this.deploymentManager.getServices().get(BeanDeploymentModules.class)) {
                    if (module.isWebModule()) continue;
                    module.fireEvent((Type)((Object)Object.class), ContextEvent.APPLICATION_DESTROYED, new Annotation[]{DestroyedLiteral.APPLICATION});
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                BeforeShutdownImpl.fire(this.deploymentManager);
                throw throwable;
            }
            finally {
                Container container = Container.instance(this.contextId);
                container.setState(ContainerState.SHUTDOWN);
                container.cleanup();
            }
        }
        try {
            for (BeanDeploymentModule module : this.deploymentManager.getServices().get(BeanDeploymentModules.class)) {
                if (module.isWebModule()) continue;
                module.fireEvent((Type)((Object)Object.class), ContextEvent.APPLICATION_DESTROYED, new Annotation[]{DestroyedLiteral.APPLICATION});
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            BeforeShutdownImpl.fire(this.deploymentManager);
            return;
        }
        finally {
            Container container = Container.instance(this.contextId);
            container.setState(ContainerState.SHUTDOWN);
            container.cleanup();
        }
    }
}

