/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.util.reflection.Reflections;

public class Formats {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String NULL = "null";
    private static final String SQUARE_BRACKETS = "[]";
    private static final String BCEL_CLASS_PARSER_FQCN = "com.sun.org.apache.bcel.internal.classfile.ClassParser";
    private static final String BCEL_JAVA_CLASS_FQCN = "com.sun.org.apache.bcel.internal.classfile.JavaClass";
    private static final String BCEL_METHOD_FQCN = "com.sun.org.apache.bcel.internal.classfile.Method";
    private static final String BCEL_LINE_NUMBER_TABLE_FQCN = "com.sun.org.apache.bcel.internal.classfile.LineNumberTable";
    private static final String BCEL_M_PARSE = "parse";
    private static final String BCEL_M_GET_METHODS = "getMethods";
    private static final String BCEL_M_GET_LINE_NUMBER_TABLE = "getLineNumberTable";
    private static final String BCEL_M_GET_SOURCE_LINE = "getSourceLine";
    private static final String BCEL_M_GET_NAME = "getName";
    private static final String BCEL_M_GET_MODIFIERS = "getModifiers";
    private static final String BCEL_M_GET_SIGNATURE = "getSignature";
    private static final String INIT_METHOD_NAME = "<init>";
    private static final String BUILD_PROPERTIES_FILE = "weld-build.properties";
    private static final String BUILD_PROPERTIES_VERSION = "version";
    private static final String BUILD_PROPERTIES_TIMESTAMP = "timestamp";
    private static final Function<?> SPACE_DELIMITER_FUNCTION = new Function<Object>(){

        @Override
        public String apply(Object from, int position) {
            if (position > 0) {
                return " " + (from == null ? Formats.NULL : from.toString());
            }
            return from == null ? Formats.NULL : from.toString();
        }
    };
    private static final Function<?> COMMA_DELIMITER_FUNCTION = new Function<Object>(){

        @Override
        public String apply(Object from, int position) {
            if (position > 0) {
                return ", " + (from == null ? Formats.NULL : from.toString());
            }
            return from == null ? Formats.NULL : from.toString();
        }
    };
    private static final Function<Annotation> ANNOTATION_LIST_FUNCTION = new Function<Annotation>(){

        @Override
        public String apply(Annotation from, int position) {
            return Formats.spaceDelimiterFunction().apply("@" + from.annotationType().getSimpleName(), position);
        }
    };

    private Formats() {
    }

    public static String formatAsStackTraceElement(InjectionPoint ij) {
        Member member;
        if (ij.getAnnotated() instanceof AnnotatedField) {
            AnnotatedField annotatedField = (AnnotatedField)ij.getAnnotated();
            member = annotatedField.getJavaMember();
        } else if (ij.getAnnotated() instanceof AnnotatedParameter) {
            AnnotatedParameter annotatedParameter = (AnnotatedParameter)ij.getAnnotated();
            member = annotatedParameter.getDeclaringCallable().getJavaMember();
        } else {
            return "-";
        }
        return Formats.formatAsStackTraceElement(member);
    }

    public static String formatAsStackTraceElement(Member member) {
        return member.getDeclaringClass().getName() + "." + (member instanceof Constructor ? INIT_METHOD_NAME : member.getName()) + "(" + Formats.getFileName(member.getDeclaringClass()) + ":" + Formats.getLineNumber(member) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLineNumber(Member member) {
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            return 0;
        }
        WeldClassLoaderResourceLoader bcelResourceLoader = WeldClassLoaderResourceLoader.INSTANCE;
        if (!Reflections.isClassLoadable(BCEL_JAVA_CLASS_FQCN, bcelResourceLoader) && !Reflections.isClassLoadable(BCEL_JAVA_CLASS_FQCN, bcelResourceLoader = DefaultResourceLoader.INSTANCE)) {
            return 0;
        }
        String classFile = member.getDeclaringClass().getName().replace('.', '/');
        ClassLoaderResourceLoader classFileResourceLoader = new ClassLoaderResourceLoader(member.getDeclaringClass().getClassLoader());
        InputStream in = null;
        try {
            Object lineNumberTable;
            String name;
            String signature;
            URL classFileUrl = classFileResourceLoader.getResource(classFile + ".class");
            if (classFileUrl == null) {
                int n = 0;
                return n;
            }
            in = classFileUrl.openStream();
            Class classParserClass = Reflections.loadClass(BCEL_CLASS_PARSER_FQCN, bcelResourceLoader);
            Class javaClassClass = Reflections.loadClass(BCEL_JAVA_CLASS_FQCN, bcelResourceLoader);
            Class methodClass = Reflections.loadClass(BCEL_METHOD_FQCN, bcelResourceLoader);
            Class lntClass = Reflections.loadClass(BCEL_LINE_NUMBER_TABLE_FQCN, bcelResourceLoader);
            Object parser = classParserClass.getConstructor(InputStream.class, String.class).newInstance(in, classFile);
            Object javaClass = classParserClass.getMethod(BCEL_M_PARSE, new Class[0]).invoke(parser, new Object[0]);
            Object[] methods = (Object[])javaClassClass.getMethod(BCEL_M_GET_METHODS, new Class[0]).invoke(javaClass, new Object[0]);
            Object match = null;
            if (member instanceof Method) {
                signature = DescriptorUtils.methodDescriptor((Method)((Method)member));
                name = member.getName();
            } else if (member instanceof Constructor) {
                signature = DescriptorUtils.makeDescriptor((Constructor)((Constructor)member));
                name = INIT_METHOD_NAME;
            } else {
                int n = 0;
                return n;
            }
            for (Object method : methods) {
                if (!methodClass.getMethod(BCEL_M_GET_NAME, new Class[0]).invoke(method, new Object[0]).equals(name) || !methodClass.getMethod(BCEL_M_GET_MODIFIERS, new Class[0]).invoke(method, new Object[0]).equals(member.getModifiers()) || !methodClass.getMethod(BCEL_M_GET_SIGNATURE, new Class[0]).invoke(method, new Object[0]).equals(signature)) continue;
                match = method;
            }
            if (match != null && (lineNumberTable = methodClass.getMethod(BCEL_M_GET_LINE_NUMBER_TABLE, new Class[0]).invoke(match, new Object[0])) != null) {
                Integer line = (Integer)lntClass.getMethod(BCEL_M_GET_SOURCE_LINE, Integer.TYPE).invoke(lineNumberTable, 0);
                int n = line == -1 ? 0 : line;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            int n = 0;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    return 0;
                }
            }
        }
    }

    private static String getFileName(Class<?> clazz) {
        return clazz.getSimpleName() + ".java";
    }

    private static <T> Function<T> spaceDelimiterFunction() {
        return SPACE_DELIMITER_FUNCTION;
    }

    private static <T> Function<T> commaDelimiterFunction() {
        return COMMA_DELIMITER_FUNCTION;
    }

    public static String formatInjectionPointType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return Formats.formatType(type);
    }

    public static String formatType(Type baseType) {
        return Formats.formatType(baseType, true);
    }

    public static String formatType(Type baseType, boolean simpleNames) {
        if (baseType == null) {
            return NULL;
        }
        if (baseType instanceof Class) {
            Class clazz = (Class)baseType;
            if (clazz.isArray()) {
                return Formats.formatType(clazz.getComponentType(), simpleNames) + SQUARE_BRACKETS;
            }
            return Formats.getClassName(clazz, simpleNames);
        }
        if (baseType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)baseType;
            return Formats.getClassName((Class)parameterizedType.getRawType(), simpleNames) + Formats.formatActualTypeArguments(parameterizedType.getActualTypeArguments());
        }
        if (baseType instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)baseType;
            return Formats.formatType(gat.getGenericComponentType(), simpleNames) + SQUARE_BRACKETS;
        }
        return baseType.toString();
    }

    private static String getClassName(Class<?> clazz, boolean simpleNames) {
        if (simpleNames) {
            return clazz.getSimpleName();
        }
        return clazz.getName();
    }

    public static String formatTypes(Iterable<? extends Type> baseTypes, final boolean simpleNames) {
        return Formats.formatIterable(baseTypes, new Function<Type>(){

            @Override
            public String apply(Type from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatType(from, simpleNames), position);
            }
        });
    }

    public static String formatTypes(Iterable<? extends Type> baseTypes) {
        return Formats.formatTypes(baseTypes, true);
    }

    public static String formatBusinessInterfaceDescriptors(Iterable<? extends BusinessInterfaceDescriptor<?>> businessInterfaceDescriptors) {
        return Formats.formatIterable(businessInterfaceDescriptors, new Function<BusinessInterfaceDescriptor<?>>(){

            @Override
            public String apply(BusinessInterfaceDescriptor<?> from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatType(from.getInterface()), position);
            }
        });
    }

    public static String addSpaceIfNeeded(String string) {
        if (string.length() > 0) {
            return string + " ";
        }
        return string;
    }

    public static String formatAsFormalParameterList(Iterable<? extends AnnotatedParameter<?>> parameters) {
        return "(" + Formats.formatIterable(parameters, new Function<AnnotatedParameter<?>>(){

            @Override
            public String apply(AnnotatedParameter<?> from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatParameter(from), position);
            }
        }) + ")";
    }

    public static String formatParameter(AnnotatedParameter<?> parameter) {
        return Formats.addSpaceIfNeeded(Formats.formatAnnotations(parameter.getAnnotations())) + Formats.formatType(parameter.getBaseType());
    }

    public static String formatModifiers(int modifiers) {
        return Formats.formatIterable(Formats.parseModifiers(modifiers), Formats.spaceDelimiterFunction());
    }

    private static <F> String formatIterable(Iterable<? extends F> items, Function<F> function) {
        if (items == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (F item : items) {
            stringBuilder.append(function.apply(item, i));
            ++i;
        }
        return stringBuilder.toString();
    }

    private static <F> String formatIterable(F[] items, Function<F> function) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (F item : items) {
            stringBuilder.append(function.apply(item, i));
            ++i;
        }
        return stringBuilder.toString();
    }

    private static List<String> parseModifiers(int modifiers) {
        ArrayList<String> result = new ArrayList<String>();
        if (Modifier.isPrivate(modifiers)) {
            result.add("private");
        }
        if (Modifier.isProtected(modifiers)) {
            result.add("protected");
        }
        if (Modifier.isPublic(modifiers)) {
            result.add("public");
        }
        if (Modifier.isAbstract(modifiers)) {
            result.add("abstract");
        }
        if (Modifier.isFinal(modifiers)) {
            result.add("final");
        }
        if (Modifier.isNative(modifiers)) {
            result.add("native");
        }
        if (Modifier.isStatic(modifiers)) {
            result.add("static");
        }
        if (Modifier.isStrict(modifiers)) {
            result.add("strict");
        }
        if (Modifier.isSynchronized(modifiers)) {
            result.add("synchronized");
        }
        if (Modifier.isTransient(modifiers)) {
            result.add("transient");
        }
        if (Modifier.isVolatile(modifiers)) {
            result.add("volatile");
        }
        if (Modifier.isInterface(modifiers)) {
            result.add("interface");
        }
        return result;
    }

    public static String formatActualTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return Formats.formatActualTypeArguments(((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments());
        }
        return "";
    }

    public static String formatActualTypeArguments(Type[] actualTypeArguments) {
        return Formats.wrapIfNecessary(Formats.formatIterable(actualTypeArguments, new Function<Type>(){

            @Override
            public String apply(Type from, int position) {
                return Formats.commaDelimiterFunction().apply(Formats.formatType(from), position);
            }
        }), "<", ">");
    }

    public static String wrapIfNecessary(String string, String prepend, String append) {
        if (string != null && string.length() > 0) {
            return prepend + string + append;
        }
        return string;
    }

    public static String formatAnnotations(Iterable<Annotation> annotations) {
        return Formats.formatIterable(annotations, ANNOTATION_LIST_FUNCTION);
    }

    public static String formatAnnotations(Annotation[] annotations) {
        return Formats.formatIterable(annotations, ANNOTATION_LIST_FUNCTION);
    }

    public static String version(@Deprecated Package pkg) {
        String version = null;
        String timestamp = null;
        Properties buildProperties = Formats.getBuildProperties();
        if (buildProperties != null) {
            version = buildProperties.getProperty(BUILD_PROPERTIES_VERSION);
            timestamp = buildProperties.getProperty(BUILD_PROPERTIES_TIMESTAMP);
        }
        if (version == null) {
            version = Formats.getManifestImplementationVersion();
        }
        return Formats.version(version, timestamp);
    }

    public static String getSimpleVersion() {
        Properties buildProperties = Formats.getBuildProperties();
        if (buildProperties != null) {
            buildProperties.getProperty(BUILD_PROPERTIES_VERSION);
        }
        return Formats.getManifestImplementationVersion();
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_MIGHT_BE_INFEASIBLE"}, justification="False positive.")
    public static String version(String version, String timestamp) {
        if (version == null && timestamp != null) {
            return timestamp;
        }
        if (version == null && timestamp == null) {
            return SNAPSHOT;
        }
        String major = null;
        String minor = null;
        String micro = null;
        String qualifier = null;
        ArrayList<String> split = new ArrayList<String>(Arrays.asList(version.split("\\.")));
        String[] split2 = ((String)split.get(split.size() - 1)).split("\\-");
        if (split2.length > 1) {
            split.remove(split.size() - 1);
            split.add(split.size(), split2[0]);
            qualifier = split2[1];
        } else if (split2.length > 0) {
            split.remove(split.size() - 1);
            qualifier = split2[0];
        }
        if (split.size() > 0) {
            major = (String)split.get(0);
        }
        if (split.size() > 1) {
            minor = (String)split.get(1);
        }
        if (split.size() > 2) {
            micro = (String)split.get(2);
        }
        if (major == null && timestamp != null) {
            return timestamp;
        }
        if (major == null && timestamp == null) {
            return SNAPSHOT;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(major);
        if (minor != null) {
            builder.append(".").append(minor);
        }
        if (minor != null && micro != null) {
            builder.append(".").append(micro);
        }
        if (qualifier != null) {
            builder.append(" (");
            if (qualifier.equals(SNAPSHOT) && timestamp != null) {
                builder.append(timestamp);
            } else {
                builder.append(qualifier);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public static String formatSimpleClassName(Object object) {
        return Formats.formatSimpleClassName(object.getClass());
    }

    public static String formatSimpleClassName(Class<?> javaClass) {
        String simpleName = javaClass.getSimpleName();
        StringBuilder builder = new StringBuilder(simpleName.length() + 2);
        builder.append("[");
        builder.append(simpleName);
        builder.append("]");
        return builder.toString();
    }

    public static String formatAnnotatedType(AnnotatedType<?> type) {
        return Formats.formatSimpleClassName(type) + " " + Formats.addSpaceIfNeeded(Formats.formatModifiers(type.getJavaClass().getModifiers())) + Formats.formatAnnotations(type.getAnnotations()) + " class " + type.getJavaClass().getName() + Formats.formatActualTypeArguments(type.getBaseType());
    }

    public static String formatAnnotatedConstructor(AnnotatedConstructor<?> constructor) {
        return Formats.formatSimpleClassName(constructor) + " " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(constructor.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(constructor.getJavaMember().getModifiers())) + constructor.getDeclaringType().getJavaClass().getName() + Formats.formatAsFormalParameterList(constructor.getParameters());
    }

    public static String formatAnnotatedField(AnnotatedField<?> field) {
        return Formats.formatSimpleClassName(field) + " " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(field.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(field.getJavaMember().getModifiers())) + field.getDeclaringType().getJavaClass().getName() + "." + field.getJavaMember().getName();
    }

    public static String formatAnnotatedMethod(AnnotatedMethod<?> method) {
        return Formats.formatSimpleClassName(method) + " " + Formats.addSpaceIfNeeded(Formats.formatAnnotations(method.getAnnotations())) + Formats.addSpaceIfNeeded(Formats.formatModifiers(method.getJavaMember().getModifiers())) + method.getDeclaringType().getJavaClass().getName() + "." + method.getJavaMember().getName() + Formats.formatAsFormalParameterList(method.getParameters());
    }

    public static String formatAnnotatedParameter(AnnotatedParameter<?> parameter) {
        return Formats.formatSimpleClassName(parameter) + " Parameter " + (parameter.getPosition() + 1) + " of " + parameter.getDeclaringCallable().toString();
    }

    public static String getNameOfMissingClassLoaderDependency(Throwable e) {
        if (e instanceof NoClassDefFoundError) {
            if (e.getCause() instanceof ClassNotFoundException) {
                return Formats.getNameOfMissingClassLoaderDependency(e.getCause());
            }
            if (e.getMessage() != null) {
                return e.getMessage().replace('/', '.');
            }
        }
        if (e instanceof ClassNotFoundException && e.getMessage() != null) {
            return e.getMessage();
        }
        if (e.getCause() != null) {
            return Formats.getNameOfMissingClassLoaderDependency(e.getCause());
        }
        return "[unknown]";
    }

    private static Properties getBuildProperties() {
        Properties buildProperties = null;
        try (InputStream in = Formats.getBuildPropertiesResource();){
            if (in != null) {
                buildProperties = new Properties();
                buildProperties.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buildProperties;
    }

    private static String getManifestImplementationVersion() {
        Package pack = WeldClassLoaderResourceLoader.class.getPackage();
        if (pack == null) {
            throw new IllegalArgumentException("Package can not be null");
        }
        return pack.getImplementationVersion();
    }

    private static InputStream getBuildPropertiesResource() {
        URL url = WeldClassLoaderResourceLoader.INSTANCE.getResource(BUILD_PROPERTIES_FILE);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static interface Function<F> {
        public String apply(F var1, int var2);
    }
}

