/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.config;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BootstrapConfiguration;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.ConfigurationLogger;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.security.GetSystemPropertyAction;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.reflection.Reflections;

public class WeldConfiguration
implements Service {
    public static final String CONFIGURATION_FILE = "weld.properties";
    private static final String EXECUTOR_CONFIGURATION_FILE = "org.jboss.weld.executor.properties";
    private static final String BOOTSTRAP_CONFIGURATION_FILE = "org.jboss.weld.bootstrap.properties";
    private static final String SYSTEM_PROPETIES = "system properties";
    private static final String OBSOLETE_SYSTEM_PROPETIES = "obsolete system properties";
    private static final String EXTERNAL_CONFIGURATION_CLASS_NAME = "org.jboss.weld.configuration.spi.ExternalConfiguration";
    private static final String UNSAFE_PROXIES_MARKER = "META-INF/org.jboss.weld.enableUnsafeProxies";
    private final Map<ConfigurationKey, Object> properties;
    private final File proxyDumpFilePath;
    private final Pattern proxyIgnoreFinalMethodsPattern;

    public WeldConfiguration(ServiceRegistry services, Deployment deployment) {
        Preconditions.checkArgumentNotNull(deployment, "deployment");
        this.properties = this.init(services, deployment);
        this.proxyDumpFilePath = this.initProxyDumpFilePath();
        this.proxyIgnoreFinalMethodsPattern = this.initProxyIgnoreFinalMethodsPattern();
        ConfigurationLogger.LOG.configurationInitialized(this.properties);
    }

    public String getStringProperty(ConfigurationKey key) {
        return this.getProperty(key, String.class);
    }

    public Boolean getBooleanProperty(ConfigurationKey key) {
        return this.getProperty(key, Boolean.class);
    }

    public Long getLongProperty(ConfigurationKey key) {
        return this.getProperty(key, Long.class);
    }

    public Integer getIntegerProperty(ConfigurationKey key) {
        return this.getProperty(key, Integer.class);
    }

    public File getProxyDumpFilePath() {
        return this.proxyDumpFilePath;
    }

    public boolean isFinalMethodIgnored(String className) {
        return this.proxyIgnoreFinalMethodsPattern != null ? this.proxyIgnoreFinalMethodsPattern.matcher(className).matches() : false;
    }

    @Override
    public void cleanup() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    static void merge(Map<ConfigurationKey, Object> original, Map<ConfigurationKey, Object> toMerge, String mergedSourceDescription) {
        for (Map.Entry<ConfigurationKey, Object> entry : toMerge.entrySet()) {
            Object existing = original.get((Object)entry.getKey());
            if (existing != null) {
                ConfigurationLogger.LOG.configurationKeyAlreadySet((Object)entry.getKey(), existing, entry.getValue(), mergedSourceDescription);
                continue;
            }
            original.put(entry.getKey(), entry.getValue());
        }
    }

    static void checkRequiredType(ConfigurationKey key, Class<?> requiredType) {
        if (!key.isValidValueType(requiredType)) {
            throw ConfigurationLogger.LOG.configurationPropertyTypeMismatch(key.getDefaultValue().getClass(), requiredType);
        }
    }

    static String getSystemProperty(String key) {
        try {
            return AccessController.doPrivileged(new GetSystemPropertyAction(key));
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private Map<ConfigurationKey, Object> init(ServiceRegistry services, Deployment deployment) {
        Map<ConfigurationKey, Object> properties = this.readFileProperties(this.findPropertiesFiles(deployment, CONFIGURATION_FILE));
        WeldConfiguration.merge(properties, this.readObsoleteFileProperties(this.findPropertiesFiles(deployment, BOOTSTRAP_CONFIGURATION_FILE), (Map<String, ConfigurationKey>)ImmutableMap.builder().put((Object)"concurrentDeployment", (Object)ConfigurationKey.CONCURRENT_DEPLOYMENT).put((Object)"preloaderThreadPoolSize", (Object)ConfigurationKey.PRELOADER_THREAD_POOL_SIZE).build()), BOOTSTRAP_CONFIGURATION_FILE);
        WeldConfiguration.merge(properties, this.readObsoleteFileProperties(this.findPropertiesFiles(deployment, EXECUTOR_CONFIGURATION_FILE), (Map<String, ConfigurationKey>)ImmutableMap.builder().put((Object)"threadPoolSize", (Object)ConfigurationKey.EXECUTOR_THREAD_POOL_SIZE).put((Object)"threadPoolDebug", (Object)ConfigurationKey.EXECUTOR_THREAD_POOL_DEBUG).put((Object)"threadPoolType", (Object)ConfigurationKey.EXECUTOR_THREAD_POOL_TYPE).put((Object)"threadPoolKeepAliveTime", (Object)ConfigurationKey.EXECUTOR_THREAD_POOL_KEEP_ALIVE_TIME).build()), EXECUTOR_CONFIGURATION_FILE);
        if (!this.findPropertiesFiles(deployment, UNSAFE_PROXIES_MARKER).isEmpty()) {
            WeldConfiguration.merge(properties, (Map<ConfigurationKey, Object>)ImmutableMap.of((Object)((Object)ConfigurationKey.RELAXED_CONSTRUCTION), (Object)true), UNSAFE_PROXIES_MARKER);
        }
        WeldConfiguration.merge(properties, this.getSystemProperties(), SYSTEM_PROPETIES);
        WeldConfiguration.merge(properties, this.getObsoleteSystemProperties(), OBSOLETE_SYSTEM_PROPETIES);
        WeldConfiguration.merge(properties, this.processExternalConfiguration(this.getExternalConfigurationOptions(services)), "ExternalConfiguration");
        WeldConfiguration.merge(properties, this.processBootstrapConfiguration(services.get(BootstrapConfiguration.class)), BootstrapConfiguration.class.getSimpleName());
        return properties;
    }

    private File initProxyDumpFilePath() {
        String dumpPath = this.getStringProperty(ConfigurationKey.PROXY_DUMP);
        if (!dumpPath.isEmpty()) {
            File tmp = new File(dumpPath);
            if (!tmp.isDirectory() && !tmp.mkdirs()) {
                BeanLogger.LOG.directoryCannotBeCreated(tmp.toString());
                return null;
            }
            return tmp;
        }
        return null;
    }

    private Pattern initProxyIgnoreFinalMethodsPattern() {
        String ignore = this.getStringProperty(ConfigurationKey.PROXY_IGNORE_FINAL_METHODS);
        if (!ignore.isEmpty()) {
            return Pattern.compile(ignore);
        }
        return null;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Only local URLs involved")
    private Set<URL> findPropertiesFiles(Deployment deployment, String fileName) {
        HashSet<ResourceLoader> resourceLoaders = new HashSet<ResourceLoader>();
        HashSet<URL> files = new HashSet<URL>();
        ResourceLoader deploymentResourceLoader = deployment.getServices().get(ResourceLoader.class);
        if (deploymentResourceLoader != null) {
            resourceLoaders.add(deploymentResourceLoader);
        }
        for (BeanDeploymentArchive archive : deployment.getBeanDeploymentArchives()) {
            ResourceLoader resourceLoader = archive.getServices().get(ResourceLoader.class);
            if (resourceLoader == null) {
                ConfigurationLogger.LOG.resourceLoaderNotSpecifiedForArchive(archive);
                continue;
            }
            resourceLoaders.add(resourceLoader);
        }
        for (ResourceLoader resourceLoader : resourceLoaders) {
            URL file = resourceLoader.getResource(fileName);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private Map<ConfigurationKey, Object> getSystemProperties() {
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (ConfigurationKey key : ConfigurationKey.values()) {
            String property = WeldConfiguration.getSystemProperty(key.get());
            if (property == null) continue;
            this.processKeyValue(found, key, (Object)property);
        }
        return found;
    }

    private Map<ConfigurationKey, Object> getObsoleteSystemProperties() {
        String preloaderThreadPoolSize;
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        String concurrentDeployment = WeldConfiguration.getSystemProperty("org.jboss.weld.bootstrap.properties.concurrentDeployment");
        if (concurrentDeployment != null) {
            this.processKeyValue(found, ConfigurationKey.CONCURRENT_DEPLOYMENT, (Object)concurrentDeployment);
            found.put(ConfigurationKey.CONCURRENT_DEPLOYMENT, ConfigurationKey.CONCURRENT_DEPLOYMENT.convertValue(concurrentDeployment));
        }
        if ((preloaderThreadPoolSize = WeldConfiguration.getSystemProperty("org.jboss.weld.bootstrap.properties.preloaderThreadPoolSize")) != null) {
            found.put(ConfigurationKey.PRELOADER_THREAD_POOL_SIZE, ConfigurationKey.PRELOADER_THREAD_POOL_SIZE.convertValue(preloaderThreadPoolSize));
        }
        return found;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Only local URLs involved")
    private Map<ConfigurationKey, Object> readFileProperties(Set<URL> files) {
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (URL file : files) {
            ConfigurationLogger.LOG.readingPropertiesFile(file);
            Properties fileProperties = this.loadProperties(file);
            for (String name : fileProperties.stringPropertyNames()) {
                this.processKeyValue(found, name, (Object)fileProperties.getProperty(name));
            }
        }
        return found;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Only local URLs involved")
    private Map<ConfigurationKey, Object> readObsoleteFileProperties(Set<URL> files, Map<String, ConfigurationKey> nameToKeyMap) {
        if (files.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (URL file : files) {
            ConfigurationLogger.LOG.readingPropertiesFile(file);
            Properties fileProperties = this.loadProperties(file);
            for (String name : fileProperties.stringPropertyNames()) {
                ConfigurationKey key = nameToKeyMap.get(name);
                if (key != null) {
                    this.processKeyValue(found, key, (Object)fileProperties.getProperty(name));
                    continue;
                }
                ConfigurationLogger.LOG.unsupportedConfigurationKeyFound(name + " in " + fileProperties);
            }
        }
        return found;
    }

    private Map<ConfigurationKey, Object> processBootstrapConfiguration(BootstrapConfiguration bootstrapConfiguration) {
        if (bootstrapConfiguration != null) {
            EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
            this.processKeyValue(found, ConfigurationKey.CONCURRENT_DEPLOYMENT, (Object)bootstrapConfiguration.isConcurrentDeploymentEnabled());
            this.processKeyValue(found, ConfigurationKey.PRELOADER_THREAD_POOL_SIZE, (Object)bootstrapConfiguration.getPreloaderThreadPoolSize());
            this.processKeyValue(found, ConfigurationKey.NON_PORTABLE_MODE, (Object)bootstrapConfiguration.isNonPortableModeEnabled());
            return found;
        }
        return Collections.emptyMap();
    }

    private Map<ConfigurationKey, Object> processExternalConfiguration(Map<String, Object> externalConfiguration) {
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (Map.Entry<String, Object> entry : externalConfiguration.entrySet()) {
            this.processKeyValue(found, entry.getKey(), entry.getValue());
        }
        return found;
    }

    private Map<String, Object> getExternalConfigurationOptions(ServiceRegistry services) {
        ExternalConfiguration externalConfiguration;
        if (Reflections.isClassLoadable(EXTERNAL_CONFIGURATION_CLASS_NAME, WeldClassLoaderResourceLoader.INSTANCE) && (externalConfiguration = services.get(ExternalConfiguration.class)) != null) {
            return externalConfiguration.getConfigurationProperties();
        }
        return Collections.emptyMap();
    }

    private void processKeyValue(Map<ConfigurationKey, Object> properties, ConfigurationKey key, Object value) {
        if (value instanceof String) {
            value = key.convertValue((String)value);
        }
        if (key.isValidValue(value)) {
            Object previous = properties.put(key, value);
            if (previous != null && !previous.equals(value)) {
                throw ConfigurationLogger.LOG.configurationKeyHasDifferentValues((Object)key, previous, value);
            }
        } else {
            throw ConfigurationLogger.LOG.invalidConfigurationPropertyValue(value, (Object)key);
        }
    }

    private void processKeyValue(Map<ConfigurationKey, Object> properties, String stringKey, Object value) {
        ConfigurationKey key = ConfigurationKey.fromString(stringKey);
        if (key != null) {
            this.processKeyValue(properties, key, value);
        } else {
            ConfigurationLogger.LOG.unsupportedConfigurationKeyFound(stringKey);
        }
    }

    private <T> T getProperty(ConfigurationKey key, Class<T> requiredType) {
        WeldConfiguration.checkRequiredType(key, requiredType);
        Object property = this.properties.get((Object)key);
        return (T)(property != null ? property : key.getDefaultValue());
    }

    private Properties loadProperties(URL url) {
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
        return properties;
    }
}

