/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.SessionBeanType;
import org.jboss.weld.bean.ForwardingBean;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bean.builtin.InstanceImpl;
import org.jboss.weld.bean.builtin.ee.EEResourceProducerField;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.collections.ImmutableMap;

final class Components {
    static final Map<String, Class<? extends Annotation>> INSPECTABLE_SCOPES = ImmutableMap.builder().put("application", ApplicationScoped.class).put("session", SessionScoped.class).put("conversation", ConversationScoped.class).build();
    static final Comparator<Class<?>> PROBE_COMPONENT_CLASS_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            int result = Boolean.compare(Components.isProbeComponent(o1), Components.isProbeComponent(o2));
            return result == 0 ? o1.getName().compareTo(o2.getName()) : result;
        }
    };
    static final Comparator<Annotation> PROBE_COMPONENT_ANNOTATION_COMPARATOR = new Comparator<Annotation>(){

        @Override
        public int compare(Annotation o1, Annotation o2) {
            int result = Boolean.compare(Components.isProbeAnnotation(o1), Components.isProbeAnnotation(o2));
            return result == 0 ? o1.annotationType().getName().compareTo(o2.annotationType().getName()) : result;
        }
    };

    private Components() {
    }

    static Object findContextualInstance(Bean<?> bean, BeanManagerImpl beanManager) {
        Context context;
        try {
            context = beanManager.getContext(bean.getScope());
        }
        catch (ContextNotActiveException e) {
            return null;
        }
        return context.get(bean);
    }

    static String getId(BeanIdentifier beanIdentifier) {
        return Components.getId(beanIdentifier.asString());
    }

    static String getId(String identifier) {
        try {
            return UUID.nameUUIDFromBytes(identifier.getBytes("UTF-8")).toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static String getBuiltinBeanId(AbstractBuiltInBean<?> builtinBean) {
        return Components.getId(builtinBean.getTypes().toString());
    }

    static Set<Dependency> getDependents(Bean<?> bean, Probe probe) {
        return Components.getDependents(bean, probe.getBeans(), probe);
    }

    static Set<Dependency> getDependents(Bean<?> bean, Collection<Bean<?>> beans, Probe probe) {
        HashSet<Dependency> dependents = new HashSet<Dependency>();
        for (Bean<?> candidate : beans) {
            Set injectionPoints;
            BeanManagerImpl beanManager;
            if (candidate.equals(bean) || (beanManager = probe.getBeanManager(candidate)) == null || (injectionPoints = candidate.getInjectionPoints()) == null || injectionPoints.isEmpty()) continue;
            for (InjectionPoint injectionPoint : injectionPoints) {
                Bean<?> lazilyFetched;
                if (injectionPoint.isDelegate()) continue;
                Bean candidateDependency = beanManager.resolve(beanManager.getBeans(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[injectionPoint.getQualifiers().size()])));
                if (candidateDependency.getBeanClass().equals(InstanceImpl.class) && (lazilyFetched = Components.getInstanceResolvedBean(beanManager, injectionPoint)) != null && lazilyFetched.equals(bean)) {
                    dependents.add(new Dependency(candidate, injectionPoint, "Most likely lazy fetching - Instance.get()", true));
                    continue;
                }
                boolean satisfies = false;
                satisfies = Components.isBuiltinBeanButNotExtension(candidateDependency) ? bean.equals(probe.getBean(Components.getBuiltinBeanId((AbstractBuiltInBean)candidateDependency))) : bean.equals((Object)candidateDependency);
                if (!satisfies) continue;
                dependents.add(new Dependency(candidate, injectionPoint));
            }
        }
        return dependents;
    }

    static Set<Dependency> getDependencies(Bean<?> bean, BeanManager beanManager, Probe probe) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        Set injectionPoints = bean.getInjectionPoints();
        if (injectionPoints != null && !injectionPoints.isEmpty()) {
            for (InjectionPoint injectionPoint : injectionPoints) {
                if (injectionPoint.isDelegate()) continue;
                Bean<?> dependency = beanManager.resolve(beanManager.getBeans(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[injectionPoint.getQualifiers().size()])));
                if (Components.isBuiltinBeanButNotExtension(dependency)) {
                    dependency = probe.getBean(Components.getBuiltinBeanId((AbstractBuiltInBean)dependency));
                }
                dependencies.add(new Dependency(dependency, injectionPoint));
            }
        }
        return dependencies;
    }

    static Bean<?> getInstanceResolvedBean(BeanManager beanManager, InjectionPoint injectionPoint) {
        try {
            Set beans = beanManager.getBeans(Components.getFacadeType(injectionPoint), injectionPoint.getQualifiers().toArray(new Annotation[injectionPoint.getQualifiers().size()]));
            if (!beans.isEmpty()) {
                return beanManager.resolve(beans);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static Type getFacadeType(InjectionPoint injectionPoint) {
        Type genericType = injectionPoint.getType();
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        throw new IllegalStateException(BeanLogger.LOG.typeParameterMustBeConcrete(injectionPoint));
    }

    static boolean isBuiltinScope(Class<? extends Annotation> scope) {
        return Dependent.class.equals(scope) || RequestScoped.class.equals(scope) || ApplicationScoped.class.equals(scope) || SessionScoped.class.equals(scope) || ConversationScoped.class.equals(scope);
    }

    static boolean isInspectableScope(String id) {
        return INSPECTABLE_SCOPES.containsKey(id);
    }

    static boolean isInspectableScope(Class<? extends Annotation> scope) {
        return INSPECTABLE_SCOPES.containsValue(scope);
    }

    static String getInspectableScopeId(Class<? extends Annotation> scope) {
        for (Map.Entry<String, Class<? extends Annotation>> inspectable : INSPECTABLE_SCOPES.entrySet()) {
            if (!inspectable.getValue().equals(scope)) continue;
            return inspectable.getKey();
        }
        return null;
    }

    static SessionBeanType getSessionBeanType(EjbDescriptor<?> ejbDescriptor) {
        if (ejbDescriptor.isStateless()) {
            return SessionBeanType.STATELESS;
        }
        if (ejbDescriptor.isStateful()) {
            return SessionBeanType.STATEFUL;
        }
        if (ejbDescriptor.isSingleton()) {
            return SessionBeanType.SINGLETON;
        }
        throw new IllegalStateException("Not a session bean");
    }

    static boolean isBuiltinBeanButNotExtension(Bean<?> bean) {
        return bean instanceof AbstractBuiltInBean && !(bean instanceof ExtensionBean);
    }

    static Integer getNumberOfEnabledBeans(BeanManagerImpl manager) {
        List<Bean<?>> enabledBeans = manager.getBeans();
        int count = 0;
        for (Bean<?> bean : enabledBeans) {
            if (Components.isBuiltinBeanButNotExtension(bean)) continue;
            ++count;
        }
        return count;
    }

    static boolean isProbeComponent(Class<?> clazz) {
        return clazz.getName().startsWith(Probe.class.getPackage().getName());
    }

    static boolean isProbeAnnotation(Annotation annotation) {
        return Components.isProbeComponent(annotation.annotationType());
    }

    static <T> List<Class<? extends T>> getSortedProbeComponetCandidates(Collection<Class<? extends T>> candidates) {
        ArrayList<Class<? extends T>> result = new ArrayList<Class<? extends T>>(candidates);
        Collections.sort(result, PROBE_COMPONENT_CLASS_COMPARATOR);
        return result;
    }

    static <T> List<Annotation> getSortedProbeComponetAnnotationCandidates(Collection<Annotation> candidates) {
        ArrayList<Annotation> result = new ArrayList<Annotation>(candidates);
        Collections.sort(result, PROBE_COMPONENT_ANNOTATION_COMPARATOR);
        return result;
    }

    static enum PriorityRange {
        PLATFORM_BEFORE,
        LIBRARY_BEFORE,
        APPLICATION,
        LIBRARY_AFTER,
        PLATFORM_AFTER,
        UNKNOWN;


        static PriorityRange of(int priority) {
            if (priority < 0 || priority >= 5000) {
                return UNKNOWN;
            }
            if (priority >= 4000) {
                return PLATFORM_AFTER;
            }
            if (priority >= 3000) {
                return LIBRARY_AFTER;
            }
            if (priority >= 2000) {
                return APPLICATION;
            }
            if (priority >= 1000) {
                return LIBRARY_BEFORE;
            }
            return PLATFORM_BEFORE;
        }
    }

    static enum BeanKind {
        MANAGED,
        SESSION,
        PRODUCER_METHOD,
        PRODUCER_FIELD,
        RESOURCE,
        SYNTHETIC,
        INTERCEPTOR,
        DECORATOR,
        EXTENSION,
        BUILT_IN;


        static BeanKind from(Bean<?> bean) {
            if (bean == null) {
                return null;
            }
            if (bean instanceof ForwardingBean) {
                ForwardingBean forwarding = (ForwardingBean)bean;
                bean = forwarding.delegate();
            }
            if (bean instanceof SessionBean) {
                return SESSION;
            }
            if (bean instanceof ManagedBean) {
                if (bean instanceof Decorator) {
                    return DECORATOR;
                }
                if (bean instanceof Interceptor) {
                    return INTERCEPTOR;
                }
                return MANAGED;
            }
            if (bean instanceof EEResourceProducerField) {
                return RESOURCE;
            }
            if (bean instanceof ProducerField) {
                return PRODUCER_FIELD;
            }
            if (bean instanceof ProducerMethod) {
                return PRODUCER_METHOD;
            }
            if (bean instanceof ExtensionBean) {
                return EXTENSION;
            }
            if (bean instanceof AbstractBuiltInBean) {
                return BUILT_IN;
            }
            return SYNTHETIC;
        }

        static BeanKind from(String value) {
            try {
                return BeanKind.valueOf(value);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class Dependency {
        private final Bean<?> bean;
        private final InjectionPoint injectionPoint;
        private final String info;
        private final boolean isPotential;

        Dependency(Bean<?> bean, InjectionPoint injectionPoint) {
            this(bean, injectionPoint, null, false);
        }

        Dependency(Bean<?> bean, InjectionPoint injectionPoint, String info, boolean isPotential) {
            this.bean = bean;
            this.injectionPoint = injectionPoint;
            this.info = info;
            this.isPotential = isPotential;
        }

        Bean<?> getBean() {
            return this.bean;
        }

        InjectionPoint getInjectionPoint() {
            return this.injectionPoint;
        }

        String getInfo() {
            return this.info;
        }

        public boolean isPotential() {
            return this.isPotential;
        }
    }
}

