package org.jboss.weld.logging;

import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-03-20T08:53:39+0100")
public class MetadataLogger_$logger extends DelegatingBasicLogger implements MetadataLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MetadataLogger_$logger.class.getName();
    public MetadataLogger_$logger(final Logger log) {
        super(log);
    }
    private static final String metaAnnotationOnWrongType = "WELD-001100: {0} can only be applied to an annotation.  It was applied to {1}";
    protected String metaAnnotationOnWrongType$str() {
        return metaAnnotationOnWrongType;
    }
    @Override
    public final DefinitionException metaAnnotationOnWrongType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(metaAnnotationOnWrongType$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void nonBindingMemberType(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, nonBindingMemberType$str(), param1);
    }
    private static final String nonBindingMemberType = "WELD-001101: Member of array type or annotation type must be annotated @NonBinding:  {0}";
    protected String nonBindingMemberType$str() {
        return nonBindingMemberType;
    }
    private static final String stereotypeNotRegistered = "WELD-001102: Stereotype {0} not registered with container";
    protected String stereotypeNotRegistered$str() {
        return stereotypeNotRegistered;
    }
    @Override
    public final IllegalStateException stereotypeNotRegistered(final Object param1) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(stereotypeNotRegistered$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String qualifierOnStereotype = "WELD-001103: Cannot declare qualifiers on stereotype {0}";
    protected String qualifierOnStereotype$str() {
        return qualifierOnStereotype;
    }
    @Override
    public final DefinitionException qualifierOnStereotype(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(qualifierOnStereotype$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueOnNamedStereotype = "WELD-001104: Cannot specify a value for @Named stereotype {0}";
    protected String valueOnNamedStereotype$str() {
        return valueOnNamedStereotype;
    }
    @Override
    public final DefinitionException valueOnNamedStereotype(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(valueOnNamedStereotype$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleScopes = "WELD-001105: At most one scope type may be specified for {0}";
    protected String multipleScopes$str() {
        return multipleScopes;
    }
    @Override
    public final DefinitionException multipleScopes(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(multipleScopes$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String stereotypesNull = "WELD-001106: BeanAttributes.getStereotypes() returned null for {0}";
    protected String stereotypesNull$str() {
        return stereotypesNull;
    }
    @Override
    public final DefinitionException stereotypesNull(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(stereotypesNull$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String qualifiersNull = "WELD-001107: {0}() returned null for {1}";
    protected String qualifiersNull$str() {
        return qualifiersNull;
    }
    @Override
    public final DefinitionException qualifiersNull(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(qualifiersNull$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typesNull = "WELD-001108: BeanAttributes.getTypes() returned null for {0}";
    protected String typesNull$str() {
        return typesNull;
    }
    @Override
    public final DefinitionException typesNull(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(typesNull$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scopeNull = "WELD-001109: BeanAttributes.getScope() returned null for {0}";
    protected String scopeNull$str() {
        return scopeNull;
    }
    @Override
    public final DefinitionException scopeNull(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(scopeNull$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAStereotype = "WELD-001110: {0} defined on {1} is not a stereotype";
    protected String notAStereotype$str() {
        return notAStereotype;
    }
    @Override
    public final DefinitionException notAStereotype(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(notAStereotype$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAQualifier = "WELD-001111: {0} defined on {1} is not a qualifier";
    protected String notAQualifier$str() {
        return notAQualifier;
    }
    @Override
    public final DefinitionException notAQualifier(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(notAQualifier$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typesEmpty = "WELD-001112: BeanAttributes.getTypes() may not return an empty set {0}";
    protected String typesEmpty$str() {
        return typesEmpty;
    }
    @Override
    public final DefinitionException typesEmpty(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(typesEmpty$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAScope = "WELD-001113: {0} defined on {1} is not a scope annotation";
    protected String notAScope$str() {
        return notAScope;
    }
    @Override
    public final DefinitionException notAScope(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(notAScope$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String metadataSourceReturnedNull = "WELD-001114: {0} returned null for {1}";
    protected String metadataSourceReturnedNull$str() {
        return metadataSourceReturnedNull;
    }
    @Override
    public final IllegalArgumentException metadataSourceReturnedNull(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(metadataSourceReturnedNull$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParameterPosition = "WELD-001115: Parameter position {0} of parameter {1} is not valid";
    protected String invalidParameterPosition$str() {
        return invalidParameterPosition;
    }
    @Override
    public final IllegalArgumentException invalidParameterPosition(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidParameterPosition$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noConstructor(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, noConstructor$str(), param1);
    }
    private static final String noConstructor = "WELD-001116: AnnotatedType ({0}) without a constructor";
    protected String noConstructor$str() {
        return noConstructor;
    }
    @Override
    public final void notInHierarchy(final Object memberName, final Object member, final Object annotatedTypeJavaClassName, final Object annotatedType, final Object stackElement) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, notInHierarchy$str(), memberName, member, annotatedTypeJavaClassName, annotatedType, stackElement);
    }
    private static final String notInHierarchy = "WELD-001117: Member {0} ({1}) does not belong to the actual class hierarchy of the annotatedType {2} ({3})\n\tat {4}";
    protected String notInHierarchy$str() {
        return notInHierarchy;
    }
    private static final String typeVariableIsNotAValidBeanType = "WELD-001118: A type variable is not a valid bean type. Bean type {0} of bean {1}";
    protected String typeVariableIsNotAValidBeanType$str() {
        return typeVariableIsNotAValidBeanType;
    }
    @Override
    public final DefinitionException typeVariableIsNotAValidBeanType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(typeVariableIsNotAValidBeanType$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterizedTypeContainingWildcardParameterIsNotAValidBeanType = "WELD-001119: A parameterized type containing wildcard parameters is not a valid bean type. Bean type {0} of bean {1}";
    protected String parameterizedTypeContainingWildcardParameterIsNotAValidBeanType$str() {
        return parameterizedTypeContainingWildcardParameterIsNotAValidBeanType;
    }
    @Override
    public final DefinitionException parameterizedTypeContainingWildcardParameterIsNotAValidBeanType(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(parameterizedTypeContainingWildcardParameterIsNotAValidBeanType$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped = "WELD-001120: A bean that has a parameterized bean type containing type variables must be @Dependent scoped. Bean type {0} of bean {1}";
    protected String beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped$str() {
        return beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped;
    }
    @Override
    public final DefinitionException beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonBindingMemberTypeException = "WELD-001121: Member of array type or annotation type must be annotated @NonBinding:  {0}";
    protected String nonBindingMemberTypeException$str() {
        return nonBindingMemberTypeException;
    }
    @Override
    public final DefinitionException nonBindingMemberTypeException(final Object param1) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(nonBindingMemberTypeException$str(), param1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String annotatedTypeDeserializationFailure = "WELD-001122: Failed to deserialize annotated type identified with {0}";
    protected String annotatedTypeDeserializationFailure$str() {
        return annotatedTypeDeserializationFailure;
    }
    @Override
    public final IllegalStateException annotatedTypeDeserializationFailure(final AnnotatedTypeIdentifier identifier) {
        final IllegalStateException result = new IllegalStateException(java.text.MessageFormat.format(annotatedTypeDeserializationFailure$str(), identifier));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnInterceptorBinding = "WELD-001123: {0} defined on {1} is not an interceptor binding";
    protected String notAnInterceptorBinding$str() {
        return notAnInterceptorBinding;
    }
    @Override
    public final DefinitionException notAnInterceptorBinding(final Object param1, final Object param2) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(notAnInterceptorBinding$str(), param1, param2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void contextGetScopeIsNotAScope(final Object param1, final Object param2) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, contextGetScopeIsNotAScope$str(), param1, param2);
    }
    private static final String contextGetScopeIsNotAScope = "WELD-001124: Context.getScope() returned {0} which is not a scope annotation. Context: {1}";
    protected String contextGetScopeIsNotAScope$str() {
        return contextGetScopeIsNotAScope;
    }
    @Override
    public final void illegalBeanTypeIgnored(final Object type, final Object annotated) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.INFO, null, illegalBeanTypeIgnored$str(), type, annotated);
    }
    private static final String illegalBeanTypeIgnored = "WELD-001125: Illegal bean type {0} ignored on {1}";
    protected String illegalBeanTypeIgnored$str() {
        return illegalBeanTypeIgnored;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
