/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.construction.api.AroundConstructCallback;
import org.jboss.weld.construction.api.ConstructionHandle;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.ForwardingInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocationContext;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class ConstructorInterceptionInstantiator<T>
extends ForwardingInstantiator<T> {
    private final InterceptionModel model;
    private final SlimAnnotatedType<?> annotatedType;

    public ConstructorInterceptionInstantiator(Instantiator<T> delegate, InterceptionModel model, SlimAnnotatedType<?> type) {
        super(delegate);
        this.model = model;
        this.annotatedType = type;
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        CreationalContextImpl weldCtx;
        if (ctx instanceof CreationalContextImpl && !(weldCtx = (CreationalContextImpl)Reflections.cast(ctx)).isConstructorInterceptionSuppressed()) {
            this.registerAroundConstructCallback(weldCtx, manager);
        }
        return this.delegate().newInstance(ctx, manager);
    }

    private void registerAroundConstructCallback(CreationalContextImpl<T> ctx, BeanManagerImpl manager) {
        final InterceptionContext interceptionContext = InterceptionContext.forConstructorInterception(this.model, ctx, manager, this.annotatedType);
        AroundConstructCallback callback = new AroundConstructCallback<T>(){

            @Override
            public T aroundConstruct(final ConstructionHandle<T> handle, AnnotatedConstructor<T> constructor, Object[] parameters, Map<String, Object> data) {
                final AtomicReference target = new AtomicReference();
                SimpleInterceptionChain chain = new SimpleInterceptionChain(ConstructorInterceptionInstantiator.this.model.getConstructorInvocationInterceptors(), interceptionContext, InterceptionType.AROUND_CONSTRUCT){

                    @Override
                    protected Object interceptorChainCompleted(InvocationContext invocationCtx) throws Exception {
                        Object instance = handle.proceed(invocationCtx.getParameters(), invocationCtx.getContextData());
                        target.set(instance);
                        return null;
                    }
                };
                InterceptorInvocationContext invocationCtx = new InterceptorInvocationContext(chain, constructor.getJavaMember(), parameters, data, ConstructorInterceptionInstantiator.this.model.getMemberInterceptorBindings(ConstructorInterceptionInstantiator.this.getConstructor())){

                    @Override
                    public Object getTarget() {
                        return target.get();
                    }
                };
                invocationCtx.getContextData().put("org.jboss.weld.interceptor.bindings", ConstructorInterceptionInstantiator.this.model.getMemberInterceptorBindings(ConstructorInterceptionInstantiator.this.getConstructor()));
                try {
                    chain.invokeNextInterceptor(invocationCtx);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new WeldException(e);
                }
                return target.get();
            }
        };
        ctx.registerAroundConstructCallback(callback);
    }

    public String toString() {
        return "ConstructorInterceptionInstantiator wrapping " + this.delegate();
    }
}

