/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotationImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;

public class ClassTransformer
implements BootstrapService {
    private final ConcurrentMap<Class<? extends Annotation>, UnbackedAnnotatedType<? extends Annotation>> syntheticAnnotationsAnnotatedTypes = new ConcurrentHashMap<Class<? extends Annotation>, UnbackedAnnotatedType<? extends Annotation>>();
    private final ConcurrentMap<AnnotatedTypeIdentifier, SlimAnnotatedType<?>> slimAnnotatedTypesById;
    private final LoadingCache<TypeHolder<?>, BackedAnnotatedType<?>> backedAnnotatedTypes;
    private final LoadingCache<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> enhancedAnnotatedTypes;
    private final LoadingCache<Class<? extends Annotation>, EnhancedAnnotation<?>> annotations;
    private final TypeStore typeStore;
    private final SharedObjectCache cache;
    private final ReflectionCache reflectionCache;
    private final String contextId;

    public static ClassTransformer instance(BeanManagerImpl manager) {
        return manager.getServices().get(ClassTransformer.class);
    }

    public ClassTransformer(TypeStore typeStore, SharedObjectCache cache, ReflectionCache reflectionCache, String contextId) {
        this.contextId = contextId;
        CacheBuilder defaultBuilder = CacheBuilder.newBuilder();
        this.backedAnnotatedTypes = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new TransformClassToBackedAnnotatedType());
        this.enhancedAnnotatedTypes = defaultBuilder.build((CacheLoader)new TransformSlimAnnotatedTypeToEnhancedAnnotatedType());
        this.annotations = defaultBuilder.build((CacheLoader)new TransformClassToWeldAnnotation());
        this.typeStore = typeStore;
        this.cache = cache;
        this.reflectionCache = reflectionCache;
        this.slimAnnotatedTypesById = new ConcurrentHashMap();
    }

    public <T> BackedAnnotatedType<T> getBackedAnnotatedType(Class<T> rawType, Type baseType, String bdaId) {
        try {
            return (BackedAnnotatedType)LoadingCacheUtils.getCastCacheValue(this.backedAnnotatedTypes, new TypeHolder(rawType, baseType, bdaId));
        }
        catch (RuntimeException e) {
            if (e instanceof TypeNotPresentException || e instanceof ResourceLoadingException) {
                BootstrapLogger.LOG.exceptionWhileLoadingClass(rawType.getName(), e);
                throw new ResourceLoadingException("Exception while loading class " + rawType.getName(), e);
            }
            throw e;
        }
        catch (ExecutionError e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoClassDefFoundError || cause instanceof LinkageError) {
                throw new ResourceLoadingException("Error while loading class " + rawType.getName(), cause);
            }
            BootstrapLogger.LOG.errorWhileLoadingClass(rawType.getName(), cause);
            throw e;
        }
    }

    public <T> BackedAnnotatedType<T> getBackedAnnotatedType(Class<T> rawType, String bdaId) {
        return this.getBackedAnnotatedType(rawType, rawType, bdaId);
    }

    public <T> SlimAnnotatedType<T> getSlimAnnotatedTypeById(AnnotatedTypeIdentifier id) {
        return (SlimAnnotatedType)Reflections.cast(this.slimAnnotatedTypesById.get(id));
    }

    public <T> UnbackedAnnotatedType<T> getUnbackedAnnotatedType(AnnotatedType<T> source, String bdaId, String suffix) {
        UnbackedAnnotatedType<T> type = UnbackedAnnotatedType.additionalAnnotatedType(this.contextId, source, bdaId, suffix, this.cache);
        return this.updateLookupTable(type);
    }

    public <T> UnbackedAnnotatedType<T> getUnbackedAnnotatedType(SlimAnnotatedType<T> originalType, AnnotatedType<T> source) {
        UnbackedAnnotatedType<T> type = UnbackedAnnotatedType.modifiedAnnotatedType(originalType, source, this.cache);
        return this.updateLookupTable(type);
    }

    public UnbackedAnnotatedType<? extends Annotation> getSyntheticAnnotationAnnotatedType(Class<? extends Annotation> annotationType) {
        return (UnbackedAnnotatedType)this.syntheticAnnotationsAnnotatedTypes.get(annotationType);
    }

    private <T, S extends SlimAnnotatedType<T>> S updateLookupTable(S annotatedType) {
        SlimAnnotatedType<?> previousValue = this.slimAnnotatedTypesById.putIfAbsent((AnnotatedTypeIdentifier)annotatedType.getIdentifier(), annotatedType);
        if (previousValue == null) {
            return annotatedType;
        }
        return (S)((SlimAnnotatedType)Reflections.cast(previousValue));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType, String bdaId) {
        return this.getEnhancedAnnotatedType(this.getBackedAnnotatedType(rawType, bdaId));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType, Type baseType, String bdaId) {
        return this.getEnhancedAnnotatedType(this.getBackedAnnotatedType(rawType, baseType, bdaId));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(AnnotatedType<T> annotatedType, String bdaId) {
        if (annotatedType instanceof EnhancedAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(annotatedType);
        }
        if (annotatedType instanceof SlimAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(this.getEnhancedAnnotatedType((SlimAnnotatedType)annotatedType));
        }
        return this.getEnhancedAnnotatedType(this.getUnbackedAnnotatedType(annotatedType, bdaId, AnnotatedTypes.createTypeId(annotatedType)));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(SlimAnnotatedType<T> annotatedType) {
        return (EnhancedAnnotatedType)LoadingCacheUtils.getCastCacheValue(this.enhancedAnnotatedTypes, annotatedType);
    }

    public <T extends Annotation> EnhancedAnnotation<T> getEnhancedAnnotation(Class<T> clazz) {
        return (EnhancedAnnotation)LoadingCacheUtils.getCastCacheValue(this.annotations, clazz);
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.annotations.invalidate(annotationClass);
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    public SharedObjectCache getSharedObjectCache() {
        return this.cache;
    }

    public ReflectionCache getReflectionCache() {
        return this.reflectionCache;
    }

    public void addSyntheticAnnotation(AnnotatedType<? extends Annotation> annotation, String bdaId) {
        this.syntheticAnnotationsAnnotatedTypes.put(annotation.getJavaClass(), this.getUnbackedAnnotatedType(annotation, bdaId, "syntheticAnnotation"));
        this.clearAnnotationData(annotation.getJavaClass());
    }

    @Override
    public void cleanupAfterBoot() {
        this.enhancedAnnotatedTypes.invalidateAll();
        this.annotations.invalidateAll();
        for (BackedAnnotatedType annotatedType : this.backedAnnotatedTypes.asMap().values()) {
            annotatedType.clear();
        }
        this.backedAnnotatedTypes.invalidateAll();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.slimAnnotatedTypesById.clear();
        this.syntheticAnnotationsAnnotatedTypes.clear();
    }

    private static final class TypeHolder<T> {
        private final String bdaId;
        private final Class<T> rawType;
        private final Type baseType;

        private TypeHolder(Class<T> rawType, Type baseType, String bdaId) {
            this.rawType = rawType;
            this.baseType = baseType;
            this.bdaId = bdaId;
        }

        public Type getBaseType() {
            return this.baseType;
        }

        public Class<T> getRawType() {
            return this.rawType;
        }

        public String getBdaId() {
            return this.bdaId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeHolder) {
                TypeHolder that = (TypeHolder)obj;
                return Objects.equal((Object)this.getBaseType(), (Object)that.getBaseType()) && Objects.equal((Object)this.getBdaId(), (Object)that.getBdaId());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getBaseType(), this.getBdaId()});
        }

        public String toString() {
            return this.getBaseType() + " from " + this.getBdaId();
        }
    }

    private class TransformSlimAnnotatedTypeToEnhancedAnnotatedType
    extends CacheLoader<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> {
        private TransformSlimAnnotatedTypeToEnhancedAnnotatedType() {
        }

        public EnhancedAnnotatedType<?> load(SlimAnnotatedType<?> annotatedType) {
            return EnhancedAnnotatedTypeImpl.of(annotatedType, ClassTransformer.this);
        }
    }

    private class TransformClassToBackedAnnotatedType
    extends CacheLoader<TypeHolder<?>, BackedAnnotatedType<?>> {
        private TransformClassToBackedAnnotatedType() {
        }

        public BackedAnnotatedType<?> load(TypeHolder<?> typeHolder) {
            Reflections.checkDeclaringClassLoadable(typeHolder.getRawType());
            BackedAnnotatedType<?> type = BackedAnnotatedType.of(typeHolder.getRawType(), typeHolder.getBaseType(), ClassTransformer.this.cache, ClassTransformer.this.reflectionCache, ClassTransformer.this.contextId, typeHolder.getBdaId());
            return (BackedAnnotatedType)ClassTransformer.this.updateLookupTable(type);
        }
    }

    private class TransformClassToWeldAnnotation
    extends CacheLoader<Class<? extends Annotation>, EnhancedAnnotation<?>> {
        private TransformClassToWeldAnnotation() {
        }

        public EnhancedAnnotation<?> load(Class<? extends Annotation> from) {
            BackedAnnotatedType<? extends Annotation> slimAnnotatedType = (BackedAnnotatedType<? extends Annotation>)ClassTransformer.this.syntheticAnnotationsAnnotatedTypes.get(from);
            if (slimAnnotatedType == null) {
                slimAnnotatedType = ClassTransformer.this.getBackedAnnotatedType(from, AnnotatedTypeIdentifier.NULL_BDA_ID);
            }
            return EnhancedAnnotationImpl.create(slimAnnotatedType, ClassTransformer.this);
        }
    }
}

