/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.Annotations;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;

public class DefaultReflectionCache
extends AbstractBootstrapService
implements ReflectionCache {
    private final TypeStore store;
    private final CacheLoader<AnnotatedElement, Set<Annotation>> ANNOTATIONS_FUNCTION = new CacheLoader<AnnotatedElement, Set<Annotation>>(){

        public Set<Annotation> load(AnnotatedElement input) {
            return ImmutableSet.copyOf((Object[])DefaultReflectionCache.this.internalGetAnnotations(input));
        }
    };
    private final CacheLoader<AnnotatedElement, Set<Annotation>> DECLARED_ANNOTATIONS_FUNCTION = new CacheLoader<AnnotatedElement, Set<Annotation>>(){

        public Set<Annotation> load(AnnotatedElement input) {
            return ImmutableSet.copyOf((Object[])DefaultReflectionCache.this.internalGetDeclaredAnnotations(input));
        }
    };
    private final LoadingCache<AnnotatedElement, Set<Annotation>> annotations;
    private final LoadingCache<AnnotatedElement, Set<Annotation>> declaredAnnotations;
    private final LoadingCache<Class<?>, Set<Annotation>> backedAnnotatedTypeAnnotations;
    private final LoadingCache<Class<? extends Annotation>, ReflectionCache.AnnotationClass<?>> annotationClasses;

    protected Annotation[] internalGetAnnotations(AnnotatedElement element) {
        return element.getAnnotations();
    }

    protected Annotation[] internalGetDeclaredAnnotations(AnnotatedElement element) {
        return element.getDeclaredAnnotations();
    }

    public DefaultReflectionCache(TypeStore store) {
        this.store = store;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        this.annotations = cacheBuilder.build(this.ANNOTATIONS_FUNCTION);
        this.declaredAnnotations = cacheBuilder.build(this.DECLARED_ANNOTATIONS_FUNCTION);
        this.backedAnnotatedTypeAnnotations = cacheBuilder.build((CacheLoader)new BackedAnnotatedTypeAnnotationsFunction());
        this.annotationClasses = cacheBuilder.build((CacheLoader)new AnnotationClassFunction());
    }

    @Override
    public void cleanupAfterBoot() {
        this.annotations.invalidateAll();
        this.declaredAnnotations.invalidateAll();
        this.backedAnnotatedTypeAnnotations.invalidateAll();
        this.annotationClasses.invalidateAll();
    }

    @Override
    public Set<Annotation> getAnnotations(AnnotatedElement element) {
        return LoadingCacheUtils.getCacheValue(this.annotations, element);
    }

    @Override
    public Set<Annotation> getDeclaredAnnotations(AnnotatedElement element) {
        return LoadingCacheUtils.getCacheValue(this.declaredAnnotations, element);
    }

    @Override
    public Set<Annotation> getBackedAnnotatedTypeAnnotationSet(Class<?> javaClass) {
        return LoadingCacheUtils.getCacheValue(this.backedAnnotatedTypeAnnotations, javaClass);
    }

    @Override
    public <T extends Annotation> ReflectionCache.AnnotationClass<T> getAnnotationClass(Class<T> clazz) {
        return (ReflectionCache.AnnotationClass)Reflections.cast(LoadingCacheUtils.getCacheValue(this.annotationClasses, clazz));
    }

    private static class AnnotationClassImpl<T extends Annotation>
    implements ReflectionCache.AnnotationClass<T> {
        private final boolean scope;
        private final Method repeatableAnnotationAccessor;
        private final Set<Annotation> metaAnnotations;

        public AnnotationClassImpl(boolean scope, Method repeatableAnnotationAccessor, Set<Annotation> metaAnnotations) {
            this.scope = scope;
            this.repeatableAnnotationAccessor = repeatableAnnotationAccessor;
            this.metaAnnotations = metaAnnotations;
        }

        @Override
        public Set<Annotation> getMetaAnnotations() {
            return this.metaAnnotations;
        }

        @Override
        public boolean isScope() {
            return this.scope;
        }

        @Override
        public boolean isRepeatableAnnotationContainer() {
            return this.repeatableAnnotationAccessor != null;
        }

        @Override
        public Annotation[] getRepeatableAnnotations(Annotation annotation) {
            if (!this.isRepeatableAnnotationContainer()) {
                throw new IllegalStateException("Not a repeatable annotation container " + annotation);
            }
            try {
                return (Annotation[])this.repeatableAnnotationAccessor.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Error reading repeatable annotations on " + annotation.annotationType(), e);
            }
        }
    }

    private class AnnotationClassFunction
    extends CacheLoader<Class<? extends Annotation>, ReflectionCache.AnnotationClass<?>> {
        private AnnotationClassFunction() {
        }

        public ReflectionCache.AnnotationClass<?> load(Class<? extends Annotation> input) {
            boolean scope = input.isAnnotationPresent(NormalScope.class) || input.isAnnotationPresent(Scope.class) || DefaultReflectionCache.this.store.isExtraScope(input);
            Method repeatableAnnotationAccessor = Annotations.getRepeatableAnnotationAccessor(input);
            ImmutableSet metaAnnotations = ImmutableSet.copyOf((Object[])DefaultReflectionCache.this.internalGetAnnotations(input));
            return new AnnotationClassImpl(scope, repeatableAnnotationAccessor, (Set<Annotation>)metaAnnotations);
        }
    }

    private class BackedAnnotatedTypeAnnotationsFunction
    extends CacheLoader<Class<?>, Set<Annotation>> {
        private BackedAnnotatedTypeAnnotationsFunction() {
        }

        public Set<Annotation> load(Class<?> javaClass) {
            Set<Annotation> annotations = DefaultReflectionCache.this.getAnnotations(javaClass);
            boolean scopeFound = false;
            for (Annotation annotation : annotations) {
                boolean isScope = DefaultReflectionCache.this.getAnnotationClass(annotation.annotationType()).isScope();
                if (isScope && scopeFound) {
                    return this.applyScopeInheritanceRules(annotations, javaClass);
                }
                if (!isScope) continue;
                scopeFound = true;
            }
            return annotations;
        }

        public Set<Annotation> applyScopeInheritanceRules(Set<Annotation> annotations, Class<?> javaClass) {
            HashSet<Annotation> result = new HashSet<Annotation>();
            for (Annotation annotation : annotations) {
                if (DefaultReflectionCache.this.getAnnotationClass(annotation.annotationType()).isScope()) continue;
                result.add(annotation);
            }
            result.addAll(this.findTopLevelScopeDefinitions(javaClass));
            return ImmutableSet.copyOf(result);
        }

        public Set<Annotation> findTopLevelScopeDefinitions(Class<?> javaClass) {
            for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                HashSet<Annotation> scopes = new HashSet<Annotation>();
                for (Annotation annotation : DefaultReflectionCache.this.getDeclaredAnnotations(clazz)) {
                    if (!DefaultReflectionCache.this.getAnnotationClass(annotation.annotationType()).isScope()) continue;
                    scopes.add(annotation);
                }
                if (scopes.size() <= 0) continue;
                return scopes;
            }
            throw new IllegalStateException();
        }
    }
}

