/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentModule;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.WeldCollections;

public final class BeanDeploymentModules
implements Service,
Iterable<BeanDeploymentModule> {
    private final ConcurrentMap<String, BeanDeploymentModule> modules;
    private final BeanDeploymentModule defaultModule;

    BeanDeploymentModules(String contextId, ServiceRegistry services) {
        this.defaultModule = new BeanDeploymentModule(BeanDeploymentModules.class.getSimpleName() + ".DEFAULT", contextId, false, services);
        this.modules = new ConcurrentHashMap<String, BeanDeploymentModule>();
    }

    public BeanDeploymentModule getModule(BeanManagerImpl manager) {
        EEModuleDescriptor descriptor = manager.getServices().get(EEModuleDescriptor.class);
        if (descriptor == null) {
            this.defaultModule.addManager(manager);
            this.modules.putIfAbsent(this.defaultModule.getId(), this.defaultModule);
            return this.defaultModule;
        }
        BeanDeploymentModule module = (BeanDeploymentModule)this.modules.get(descriptor.getId());
        if (module == null) {
            module = new BeanDeploymentModule(descriptor.getId(), manager.getContextId(), descriptor.getType() == EEModuleDescriptor.ModuleType.WEB, manager.getServices());
            module = WeldCollections.putIfAbsent(this.modules, descriptor.getId(), module);
        }
        module.addManager(manager);
        return module;
    }

    public void processBeanDeployments(Iterable<BeanDeployment> deployments) {
        for (BeanDeployment deployment : deployments) {
            this.getModule(deployment.getBeanManager());
        }
    }

    @Override
    public void cleanup() {
        this.modules.clear();
    }

    @Override
    public Iterator<BeanDeploymentModule> iterator() {
        return this.modules.values().iterator();
    }

    public String toString() {
        return this.modules.values().toString();
    }
}

