/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface EventLogger
extends WeldLogger {
    public static final EventLogger LOG = (EventLogger)Logger.getMessageLogger(EventLogger.class, (String)Category.EVENT.getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400, value="Sending event {0} directly to observer {1}", format=Message.Format.MESSAGE_FORMAT)
    public void asyncFire(Object var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=401, value="Failure while notifying an observer of event {0}", format=Message.Format.MESSAGE_FORMAT)
    public void asyncObserverFailure(Object var1);

    @Message(id=403, value="Proxy required")
    public InvalidObjectException proxyRequired();

    @Message(id=404, value="Conditional observer method [{0}] cannot be declared by a @Dependent scoped bean", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidScopedConditionalObserver(Object var1);

    @Message(id=405, value="Observer method [{0}] cannot have more than one event parameter annotated @Observes", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException multipleEventParameters(Object var1);

    @Message(id=406, value="Observer method [{0}] cannot have a parameter annotated with @Disposes", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidDisposesParameter(Object var1);

    @Message(id=407, value="Observer method [{0}] cannot be annotated with @Produces", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidProducer(Object var1);

    @Message(id=408, value="Observer method [{0}] cannot be annotated with @Inject; observer methods are automatically injection points", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidInitializer(Object var1);

    @Message(id=409, value="Observer method for container lifecycle event [{0}] can only inject BeanManager.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidInjectionPoint(Object var1);

    @Message(id=410, value="Observer method {0} cannot define @WithAnnotations", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidWithAnnotations(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=411, value="Observer method {0} receives events for all annotated types. Consider restricting events using @WithAnnotations or a generic type with bounds.", format=Message.Format.MESSAGE_FORMAT)
    public void unrestrictedProcessAnnotatedTypes(Object var1);

    @Message(id=412, value="ObserverMethod.{0}() returned null for {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException observerMethodsMethodReturnsNull(Object var1, Object var2);

    @Message(id=413, value="{0} cannot be replaced by an observer method with a different bean class {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException beanClassMismatch(ObserverMethod<?> var1, ObserverMethod<?> var2);
}

