/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.collections.SetMultimap;
import org.jboss.weld.util.reflection.Reflections;

class EjbDescriptors {
    private final Map<String, InternalEjbDescriptor<?>> ejbByName = new HashMap();
    private final SetMultimap<Class<?>, String> ejbByClass = SetMultimap.newSetMultimap();

    EjbDescriptors(Collection<EjbDescriptor<?>> descriptors) {
        this.addAll(descriptors);
    }

    public <T> InternalEjbDescriptor<T> get(String beanName) {
        return (InternalEjbDescriptor)Reflections.cast(this.ejbByName.get(beanName));
    }

    private <T> void add(EjbDescriptor<T> ejbDescriptor) {
        InternalEjbDescriptor<T> internalEjbDescriptor = InternalEjbDescriptor.of(ejbDescriptor);
        this.ejbByName.put(ejbDescriptor.getEjbName(), internalEjbDescriptor);
        this.ejbByClass.put(ejbDescriptor.getBeanClass(), (Object)internalEjbDescriptor.getEjbName());
    }

    public boolean contains(String beanName) {
        return this.ejbByName.containsKey(beanName);
    }

    public boolean contains(Class<?> beanClass) {
        return this.ejbByClass.containsKey(beanClass);
    }

    public <T> InternalEjbDescriptor<T> getUnique(Class<T> beanClass) {
        Set ejbs = (Set)this.ejbByClass.get(beanClass);
        if (ejbs.size() > 1) {
            throw BeanLogger.LOG.tooManyEjbsForClass(beanClass, ejbs);
        }
        if (ejbs.size() == 0) {
            return null;
        }
        return this.get((String)ejbs.iterator().next());
    }

    private void addAll(Iterable<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.add(ejbDescriptor);
        }
    }

    public Iterator<InternalEjbDescriptor<?>> iterator() {
        return this.ejbByName.values().iterator();
    }

    public Collection<InternalEjbDescriptor<?>> getAll() {
        return this.ejbByName.values();
    }

    public void cleanup() {
        this.ejbByClass.clear();
        this.ejbByName.clear();
    }
}

