/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.regex.Pattern;
import javax.decorator.Decorator;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.interceptor.Interceptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.probe.InvocationMonitor;
import org.jboss.weld.probe.Monitored;
import org.jboss.weld.probe.MonitoredComponent;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeDynamicMBean;
import org.jboss.weld.probe.ProbeJsonData;
import org.jboss.weld.probe.ProbeJsonDataMXBean;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.ProbeObserver;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.collections.ImmutableSet;

public class ProbeExtension
implements Extension {
    private final Probe probe = new Probe();
    private volatile Pattern invocationMonitorExcludePattern;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        ProbeLogger.LOG.developmentModeEnabled();
        BeanManagerImpl manager = BeanManagerProxy.unwrap(beanManager);
        event.addAnnotatedType(manager.createAnnotatedType(Monitored.class), Monitored.class.getName());
        event.addAnnotatedType(manager.createAnnotatedType(MonitoredComponent.class), MonitoredComponent.class.getName());
        event.addAnnotatedType(manager.createAnnotatedType(InvocationMonitor.class), InvocationMonitor.class.getName());
        String exclude = manager.getServices().get(WeldConfiguration.class).getStringProperty(ConfigurationKey.PROBE_INVOCATION_MONITOR_EXCLUDE_TYPE);
        this.invocationMonitorExcludePattern = exclude.isEmpty() ? null : Pattern.compile(exclude);
    }

    public <T> void processBeanAttributes(@Observes ProcessBeanAttributes<T> event, BeanManager beanManager) {
        final BeanAttributes beanAttributes = event.getBeanAttributes();
        WeldManager weldManager = (WeldManager)beanManager;
        if (this.isMonitored(event.getAnnotated(), beanAttributes, weldManager)) {
            event.setBeanAttributes((BeanAttributes)new ForwardingBeanAttributes<T>(){

                @Override
                public Set<Class<? extends Annotation>> getStereotypes() {
                    return ImmutableSet.builder().addAll(this.attributes().getStereotypes()).add(MonitoredComponent.class).build();
                }

                @Override
                protected BeanAttributes<T> attributes() {
                    return beanAttributes;
                }
            });
            ProbeLogger.LOG.monitoringStereotypeAdded(event.getAnnotated());
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        BeanManagerImpl weldManager;
        String exclude = (weldManager = BeanManagerProxy.unwrap(beanManager)).getServices().get(WeldConfiguration.class).getStringProperty(ConfigurationKey.PROBE_EVENT_MONITOR_EXCLUDE_TYPE);
        event.addObserverMethod((ObserverMethod)new ProbeObserver(weldManager, exclude.isEmpty() ? null : Pattern.compile(exclude), this.probe));
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        BeanManagerImpl manager = BeanManagerProxy.unwrap(beanManager);
        this.probe.init(manager);
        if (this.isJMXSupportEnabled(manager)) {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(new ProbeDynamicMBean(new ProbeJsonData(this.probe, BeanManagerProxy.unwrap(beanManager)), ProbeJsonDataMXBean.class), this.constructProbeJsonDataMBeanName(manager, this.probe));
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                event.addDeploymentProblem((Throwable)ProbeLogger.LOG.unableToRegisterMBean(ProbeJsonDataMXBean.class, manager.getContextId(), e));
            }
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown event, BeanManager beanManager) {
        BeanManagerImpl manager = BeanManagerProxy.unwrap(beanManager);
        if (this.isJMXSupportEnabled(manager)) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = this.constructProbeJsonDataMBeanName(manager, this.probe);
                if (mbs.isRegistered(name)) {
                    mbs.unregisterMBean(name);
                }
            }
            catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
                throw ProbeLogger.LOG.unableToUnregisterMBean(ProbeJsonDataMXBean.class, manager.getContextId(), e);
            }
        }
    }

    Probe getProbe() {
        return this.probe;
    }

    private boolean isJMXSupportEnabled(BeanManagerImpl manager) {
        return manager.getServices().get(WeldConfiguration.class).getBooleanProperty(ConfigurationKey.PROBE_JMX_SUPPORT);
    }

    private ObjectName constructProbeJsonDataMBeanName(BeanManagerImpl manager, Probe probe) throws MalformedObjectNameException {
        return new ObjectName(Probe.class.getPackage().getName() + ":type=JsonData,context=" + ObjectName.quote(manager.getContextId() + "_" + probe.getInitTs()));
    }

    private <T> boolean isMonitored(Annotated annotated, BeanAttributes<T> beanAttributes, WeldManager weldManager) {
        if (annotated.isAnnotationPresent(Interceptor.class) || annotated.isAnnotationPresent(Decorator.class)) {
            return false;
        }
        Type type = annotated instanceof AnnotatedMember ? ((AnnotatedMember)annotated).getDeclaringType().getBaseType() : annotated.getBaseType();
        UnproxyableResolutionException unproxyableException = Proxies.getUnproxyableTypeException(type, weldManager.getServices());
        if (unproxyableException != null) {
            ProbeLogger.LOG.invocationMonitorNotAssociatedNonProxyableType(type);
            ProbeLogger.LOG.catchingTrace((Throwable)((Object)unproxyableException));
            return false;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (this.invocationMonitorExcludePattern != null && this.invocationMonitorExcludePattern.matcher(clazz.getName()).matches()) {
                ProbeLogger.LOG.invocationMonitorNotAssociatedExcluded(clazz.getName());
                return false;
            }
        }
        return true;
    }
}

