/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.experimental.ExperimentalProcessObserverMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.WeldCollections;

public class ProcessObserverMethodImpl<T, X>
extends AbstractDefinitionContainerEvent
implements ProcessObserverMethod<T, X>,
ExperimentalProcessObserverMethod<T, X> {
    private final AnnotatedMethod<X> beanMethod;
    private final ObserverMethod<T> initialObserverMethod;
    private ObserverMethod<T> observerMethod;
    private boolean vetoed;

    public static <T, X> ObserverMethod<T> fire(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod) {
        ProcessObserverMethodImpl event = new ProcessObserverMethodImpl<T, X>(beanManager, (AnnotatedMethod)beanMethod, (ObserverMethod)observerMethod){};
        event.fire();
        if (event.vetoed) {
            return null;
        }
        if (event.isDirty()) {
            return event.observerMethod;
        }
        return observerMethod;
    }

    private ProcessObserverMethodImpl(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethod<T> observerMethod) {
        super(beanManager, (Type)((Object)ExperimentalProcessObserverMethod.class), new Type[]{observerMethod.getObservedType(), observerMethod.getBeanClass()});
        this.beanMethod = beanMethod;
        this.initialObserverMethod = observerMethod;
        this.observerMethod = observerMethod;
    }

    public AnnotatedMethod<X> getAnnotatedMethod() {
        this.checkWithinObserverNotification();
        return this.beanMethod;
    }

    public ObserverMethod<T> getObserverMethod() {
        this.checkWithinObserverNotification();
        return this.observerMethod;
    }

    public List<Throwable> getDefinitionErrors() {
        return WeldCollections.immutableListView(this.getErrors());
    }

    @Override
    public void setObserverMethod(ObserverMethod<T> observerMethod) {
        Preconditions.checkArgumentNotNull(observerMethod, "observerMethod");
        this.checkWithinObserverNotification();
        Observers.validateObserverMethod(observerMethod, this.getBeanManager(), this.initialObserverMethod);
        this.observerMethod = observerMethod;
    }

    @Override
    public void veto() {
        this.checkWithinObserverNotification();
        this.vetoed = true;
    }

    public boolean isDirty() {
        return this.observerMethod != this.initialObserverMethod;
    }
}

